/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.openimaj.hadoop.sequencefile.MetadataConfiguration;

public class MetadataSequenceFileOutputFormat<K, V>
extends SequenceFileOutputFormat<K, V> {
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (MetadataSequenceFileOutputFormat.getCompressOutput((JobContext)context)) {
            compressionType = MetadataSequenceFileOutputFormat.getOutputCompressionType((JobContext)context);
            Class codecClass = MetadataSequenceFileOutputFormat.getOutputCompressorClass((JobContext)context, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
        }
        Path file = this.getDefaultWorkFile(context, "");
        FileSystem fs = file.getFileSystem(conf);
        SequenceFile.Metadata md = MetadataConfiguration.getMetadata(conf);
        final SequenceFile.Writer out = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, (Class)context.getOutputKeyClass(), (Class)context.getOutputValueClass(), (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, (Progressable)context, (SequenceFile.Metadata)md);
        return new RecordWriter<K, V>(){

            public void write(K key, V value) throws IOException {
                out.append(key, value);
            }

            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }
}

