/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile;

import java.util.Arrays;
import org.openimaj.data.RandomData;

public class ExtractionState {
    private int count = 0;
    private int max = -1;
    private int[] randomInts = null;

    public int getCount() {
        return this.count;
    }

    protected boolean allowNext() {
        if (this.max != -1 && this.count >= this.max) {
            return false;
        }
        if (this.randomInts == null) {
            return true;
        }
        int thingLocation = Arrays.binarySearch(this.randomInts, this.count);
        return thingLocation >= 0;
    }

    public boolean isFinished() {
        return this.max != -1 && this.count >= this.max;
    }

    protected void tick() {
        ++this.count;
    }

    public void setRandomSelection(int number, int total) {
        this.randomInts = RandomData.getUniqueRandomInts((int)number, (int)0, (int)total);
        Arrays.sort(this.randomInts);
        System.out.println(this.randomInts.length + " random ints selected");
        System.out.println(Arrays.toString(this.randomInts));
    }

    public void setMaxFileExtract(int max) {
        this.max = max;
    }
}

