/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.openimaj.hadoop.sequencefile.MetadataConfiguration;
import org.openimaj.hadoop.sequencefile.MetadataSequenceFileOutputFormat;

public class TextBytesJobUtil {
    public static Job createJob(String inputPath, String outputPath, Map<String, String> metadata, Configuration config) throws IOException {
        return TextBytesJobUtil.createJob(new Path(inputPath), new Path(outputPath), metadata, config);
    }

    public static Job createJob(Collection<String> inputPaths, String outputPath, Map<String, String> metadata, Configuration config) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String s : inputPaths) {
            paths.add(new Path(s));
        }
        return TextBytesJobUtil.createJob(paths, new Path(outputPath), metadata, config);
    }

    public static Job createJob(Path inputPath, Path outputPath, Map<String, String> metadata, Configuration config) throws IOException {
        return TextBytesJobUtil.createJob(new Path[]{inputPath}, outputPath, metadata, config);
    }

    public static Job createJob(Collection<Path> inputPaths, Path outputPath, Map<String, String> metadata, Configuration config) throws IOException {
        return TextBytesJobUtil.createJob(inputPaths.toArray(new Path[inputPaths.size()]), outputPath, metadata, config);
    }

    public static Job createJob(Path[] inputPaths, Path outputPath, Map<String, String> metadata, Configuration config) throws IOException {
        Job job = new Job(config);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(BytesWritable.class);
        job.setOutputFormatClass(MetadataSequenceFileOutputFormat.class);
        SequenceFileInputFormat.setInputPaths((Job)job, (Path[])inputPaths);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        SequenceFileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        SequenceFileOutputFormat.setOutputCompressorClass((Job)job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        if (metadata != null) {
            MetadataConfiguration.setMetadata(metadata, job.getConfiguration());
        }
        return job;
    }
}

