/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BinaryAttachment;
import com.restfb.Connection;
import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.batch.BatchRequest;
import com.restfb.batch.BatchResponse;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.UrlUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FacebookClient {
    public <T> T fetchObject(String var1, Class<T> var2, Parameter ... var3);

    public <T> T fetchObjects(List<String> var1, Class<T> var2, Parameter ... var3);

    public <T> Connection<T> fetchConnection(String var1, Class<T> var2, Parameter ... var3);

    public <T> Connection<T> fetchConnectionPage(String var1, Class<T> var2);

    public <T> List<T> executeQuery(String var1, Class<T> var2, Parameter ... var3);

    public <T> T executeMultiquery(Map<String, String> var1, Class<T> var2, Parameter ... var3);

    public List<BatchResponse> executeBatch(BatchRequest ... var1);

    public List<BatchResponse> executeBatch(List<BatchRequest> var1, List<BinaryAttachment> var2);

    public <T> T publish(String var1, Class<T> var2, Parameter ... var3);

    public <T> T publish(String var1, Class<T> var2, BinaryAttachment var3, Parameter ... var4);

    public boolean deleteObject(String var1, Parameter ... var2);

    public List<AccessToken> convertSessionKeysToAccessTokens(String var1, String var2, String ... var3);

    public AccessToken obtainAppAccessToken(String var1, String var2);

    public AccessToken obtainExtendedAccessToken(String var1, String var2, String var3);

    public JsonMapper getJsonMapper();

    public WebRequestor getWebRequestor();

    public static class AccessToken {
        @Facebook(value="access_token")
        private String accessToken;
        @Facebook
        private Long expires;

        public static AccessToken fromQueryString(String string) {
            Map<String, List<String>> map = UrlUtils.extractParametersFromQueryString(string);
            String string2 = null;
            if (map.containsKey("access_token")) {
                string2 = map.get("access_token").get(0);
            }
            if (string2 == null) {
                throw new IllegalArgumentException(String.format("Was expecting a query string of the form 'access_token=XXX' or 'access_token=XXX&expires=YYY'. Instead, the query string was '%s'", string));
            }
            Long l = null;
            if (map.containsKey("expires")) {
                try {
                    l = Long.valueOf(map.get("expires").get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            AccessToken accessToken = new AccessToken();
            accessToken.accessToken = string2;
            accessToken.expires = l;
            return accessToken;
        }

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpires() {
            return this.expires == null ? null : new Date(1000L * this.expires);
        }
    }
}

