/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.OoxmlUtils;
import net.sf.jasperreports.engine.export.ooxml.type.PaperSizeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;

public class DocxDocumentHelper
extends BaseHelper {
    protected static int DEFAULT_LINE_PITCH = 360;

    public DocxDocumentHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<w:document\n");
        this.write(" xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\"\n");
        this.write(" xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n");
        this.write(" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\"\n");
        this.write(" xmlns:v=\"urn:schemas-microsoft-com:vml\"\n");
        this.write(" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\"\n");
        this.write(" xmlns:w10=\"urn:schemas-microsoft-com:office:word\"\n");
        this.write(" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"\n");
        this.write(" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\"\n");
        this.write(" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"\n");
        this.write(" xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">\n");
        this.write(" <w:body>\n");
    }

    public void exportSection(PrintPageFormat pageFormat, JRGridLayout pageGridLayout, boolean lastPage) {
        int gridBottomPadding;
        int bottomMargin;
        if (!lastPage) {
            this.write("    <w:p>\n");
            this.write("    <w:pPr>\n");
        }
        this.write("  <w:sectPr>\n");
        this.write("   <w:pgSz w:w=\"" + LengthUtil.twip(pageFormat.getPageWidth().intValue()) + "\" w:h=\"" + LengthUtil.twip(pageFormat.getPageHeight().intValue()) + "\"");
        this.write(" w:orient=\"" + (pageFormat.getOrientation() == OrientationEnum.LANDSCAPE ? "landscape" : "portrait") + "\"");
        if (OoxmlUtils.getSuitablePaperSize(pageFormat) == PaperSizeEnum.UNDEFINED) {
            this.write(" w:code=\"" + (1000 + pageFormat.getPageWidth() + pageFormat.getPageHeight()) + "\"");
        }
        this.write("/>\n");
        CutsInfo xCuts = pageGridLayout.getXCuts();
        Cut leftCut = xCuts.getCut(0);
        int gridLeftPadding = leftCut.isCutNotEmpty() ? 0 : pageGridLayout.getColumnWidth(0);
        int leftMargin = Math.min(gridLeftPadding, pageFormat.getLeftMargin());
        Cut rightCut = xCuts.getCut(xCuts.size() - 2);
        int gridRightPadding = rightCut.isCutNotEmpty() ? 0 : pageGridLayout.getColumnWidth(xCuts.size() - 2);
        int rightMargin = Math.min(gridRightPadding, pageFormat.getRightMargin());
        CutsInfo yCuts = pageGridLayout.getYCuts();
        int topMargin = pageFormat.getTopMargin();
        if (yCuts.size() > 1) {
            Cut topCut = yCuts.getCut(0);
            int gridTopPadding = topCut.isCutNotEmpty() ? 0 : pageGridLayout.getRowHeight(0);
            topMargin = Math.min(gridTopPadding, pageFormat.getTopMargin());
        }
        bottomMargin = (bottomMargin = LengthUtil.twip(Math.min(gridBottomPadding = pageFormat.getPageHeight() - yCuts.getLastCutOffset(), pageFormat.getBottomMargin())) - DEFAULT_LINE_PITCH) < 0 ? 0 : bottomMargin;
        this.write("   <w:pgMar w:top=\"" + LengthUtil.twip(topMargin) + "\" w:right=\"" + LengthUtil.twip(rightMargin) + "\" w:bottom=\"" + bottomMargin + "\" w:left=\"" + LengthUtil.twip(leftMargin) + "\" w:header=\"0\" w:footer=\"0\" w:gutter=\"0\" />\n");
        this.write("   <w:docGrid w:linePitch=\"" + DEFAULT_LINE_PITCH + "\" />\n");
        this.write("  </w:sectPr>\n");
        if (!lastPage) {
            this.write("    </w:pPr>\n");
            this.write("    </w:p>\n");
        }
    }

    public void exportFooter() {
        this.write(" </w:body>\n");
        this.write("</w:document>\n");
    }
}

