/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseElementDataset
implements JRElementDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected ResetTypeEnum resetTypeValue = ResetTypeEnum.REPORT;
    protected IncrementTypeEnum incrementTypeValue = IncrementTypeEnum.NONE;
    protected JRGroup resetGroup;
    protected JRGroup incrementGroup;
    protected JRDatasetRun datasetRun;
    protected JRExpression incrementWhenExpression;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private byte resetType;
    private byte incrementType;

    protected JRBaseElementDataset() {
    }

    protected JRBaseElementDataset(JRElementDataset dataset) {
        if (dataset != null) {
            this.resetTypeValue = dataset.getResetTypeValue();
            this.incrementTypeValue = dataset.getIncrementTypeValue();
            this.resetGroup = dataset.getResetGroup();
            this.incrementGroup = dataset.getIncrementGroup();
            this.datasetRun = dataset.getDatasetRun();
            this.incrementWhenExpression = dataset.getIncrementWhenExpression();
        }
    }

    protected JRBaseElementDataset(JRElementDataset dataset, JRBaseObjectFactory factory) {
        factory.put(dataset, this);
        this.resetTypeValue = dataset.getResetTypeValue();
        this.incrementTypeValue = dataset.getIncrementTypeValue();
        this.resetGroup = factory.getGroup(dataset.getResetGroup());
        this.incrementGroup = factory.getGroup(dataset.getIncrementGroup());
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
        this.incrementWhenExpression = factory.getExpression(dataset.getIncrementWhenExpression());
    }

    @Override
    public ResetTypeEnum getResetTypeValue() {
        return this.resetTypeValue;
    }

    @Override
    public IncrementTypeEnum getIncrementTypeValue() {
        return this.incrementTypeValue;
    }

    @Override
    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    @Override
    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    @Override
    public JRExpression getIncrementWhenExpression() {
        return this.incrementWhenExpression;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.resetTypeValue = ResetTypeEnum.getByValue(this.resetType);
            this.incrementTypeValue = IncrementTypeEnum.getByValue(this.incrementType);
        }
    }

    @Override
    public Object clone() {
        JRBaseElementDataset clone = null;
        try {
            clone = (JRBaseElementDataset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.incrementWhenExpression = JRCloneUtils.nullSafeClone(this.incrementWhenExpression);
        clone.datasetRun = JRCloneUtils.nullSafeClone(this.datasetRun);
        return clone;
    }
}

