/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.BigDecimalValuesIterator;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;

public class BigDecimalValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private ColumnValues unscaledValues;
    private ColumnValues scaleValues;

    public BigDecimalValues(ColumnValues unscaledValues, ColumnValues scaleValues) {
        if (unscaledValues.size() != scaleValues.size()) {
            throw new IllegalArgumentException();
        }
        this.unscaledValues = unscaledValues;
        this.scaleValues = scaleValues;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUnshared(this.unscaledValues);
        out.writeUnshared(this.scaleValues);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.unscaledValues = (ColumnValues)in.readUnshared();
        this.scaleValues = (ColumnValues)in.readUnshared();
    }

    @Override
    public int size() {
        return this.unscaledValues.size();
    }

    @Override
    public ColumnValuesIterator iterator() {
        ColumnValuesIterator unscaledIterator = this.unscaledValues.iterator();
        ColumnValuesIterator scaleIterator = this.scaleValues.iterator();
        return new BigDecimalValuesIterator(unscaledIterator, scaleIterator);
    }
}

