/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;

public class MapElementHtmlHandler
implements GenericElementHtmlHandler {
    private static final MapElementHtmlHandler INSTANCE = new MapElementHtmlHandler();
    private static final String MAP_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/map/resources/templates/MapElementHtmlTemplate.vm";
    private static final String FIRST_ATTEMPT_PARAM = "exporter_first_attempt";

    public static MapElementHtmlHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        ReportContext reportContext = context.getExporterRef().getReportContext();
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("mapCanvasId", "map_canvas_" + element.hashCode());
        HtmlExporter htmlExporter = (HtmlExporter)context.getExporterRef();
        contextMap.put("elementX", htmlExporter.toSizeUnit((float)element.getX()));
        contextMap.put("elementY", htmlExporter.toSizeUnit((float)element.getY()));
        contextMap.put("elementWidth", element.getWidth());
        contextMap.put("elementHeight", element.getHeight());
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            contextMap.put("backgroundColor", JRColorUtil.getColorHexa(element.getBackcolor()));
        }
        contextMap.put("gotReportContext", reportContext != null);
        if (reportContext == null) {
            Float latitude = (Float)element.getParameterValue("latitude");
            latitude = latitude == null ? MapComponent.DEFAULT_LATITUDE : latitude;
            Float longitude = (Float)element.getParameterValue("longitude");
            longitude = longitude == null ? MapComponent.DEFAULT_LONGITUDE : longitude;
            Integer zoom = (Integer)element.getParameterValue("zoom");
            zoom = zoom == null ? MapComponent.DEFAULT_ZOOM : zoom;
            String mapType = (String)element.getParameterValue("mapType");
            mapType = (mapType == null ? MapComponent.DEFAULT_MAP_TYPE.getName() : mapType).toUpperCase();
            contextMap.put("latitude", latitude);
            contextMap.put("longitude", longitude);
            contextMap.put("zoom", zoom);
            contextMap.put("mapType", mapType);
            List markerList = (List)element.getParameterValue("markers");
            String markers = markerList == null || markerList.isEmpty() ? "[]" : JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(markerList);
            contextMap.put("markerList", markers);
            List pathList = (List)element.getParameterValue("paths");
            String paths = pathList == null || pathList.isEmpty() ? "[]" : JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(pathList);
            contextMap.put("pathsList", paths);
            String reqParams = (String)element.getParameterValue("reqParams");
            if (reqParams != null) {
                contextMap.put("reqParams", reqParams);
            }
            if (context.getValue(FIRST_ATTEMPT_PARAM) == null) {
                context.setValue(FIRST_ATTEMPT_PARAM, true);
                contextMap.put("exporterFirstAttempt", true);
            }
        }
        return VelocityUtil.processTemplate(MAP_ELEMENT_HTML_TEMPLATE, contextMap);
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

