/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.FixedSizeSampleAudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.video.xuggle.XuggleAudio;

public class OneSecondClipReader
implements InputStreamObjectReader<List<SampleBuffer>> {
    public List<SampleBuffer> read(InputStream stream) throws IOException {
        XuggleAudio xa = new XuggleAudio(stream);
        int nSamplesInOneSecond = (int)(xa.getFormat().getSampleRateKHz() * 1000.0);
        FixedSizeSampleAudioProcessor f = new FixedSizeSampleAudioProcessor((AudioStream)xa, nSamplesInOneSecond);
        ArrayList<SampleBuffer> buffers = new ArrayList<SampleBuffer>();
        SampleChunk sc = null;
        while ((sc = f.nextSampleChunk()) != null) {
            buffers.add(sc.getSampleBuffer());
        }
        System.out.println("Got " + buffers.size() + " one-second sample buffers.");
        return buffers;
    }

    public boolean canRead(InputStream stream, String name) {
        return true;
    }
}

