/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.generation;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.Instrument;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.generation.Oscillator;
import org.openimaj.audio.generation.SynthesizerListener;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.util.WesternScaleNote;

public class Synthesizer
extends AudioStream
implements Instrument {
    private double currentTime = 0.0;
    private double currentTimeMS = 0.0;
    private Oscillator oscillator = new Oscillator.SineOscillator();
    private final int sampleChunkLength = 1024;
    private double frequency = 440.0;
    private int gain = Integer.MAX_VALUE;
    private double noteOnTime = 0.0;
    private boolean noteOn = true;
    private boolean noteOff = false;
    private double noteOffTime = 0.0;
    private long attack = 0L;
    private long decay = 0L;
    private float sustain = 1.0f;
    private long release = 0L;
    private float currentADSRValue = 0.0f;
    private char envelopePhase = (char)78;
    private final List<SynthesizerListener> listeners = new ArrayList<SynthesizerListener>();

    public Synthesizer() {
        this.setFormat(new AudioFormat(16, 44.1, 1));
    }

    public SampleChunk nextSampleChunk() {
        Oscillator o = this.oscillator;
        if (!this.noteOn) {
            return null;
        }
        SampleChunk x = o.getSampleChunk(this.sampleChunkLength, this.currentTime, this.frequency, this.gain, this.format);
        this.applyADSREnvelope(x.getSampleBuffer());
        this.currentTime += (double)x.getSampleBuffer().size() / (this.format.getSampleRateKHz() * 1000.0);
        this.currentTimeMS = this.currentTime * 1000.0;
        return x;
    }

    public void setFrequency(double f) {
        this.frequency = f;
    }

    public void setGain(int gain) {
        this.gain = gain;
    }

    public void setOscillatorType(Oscillator t) {
        this.oscillator = t;
    }

    public Oscillator getOscillator() {
        return this.oscillator;
    }

    public void reset() {
        this.currentTime = 0.0;
    }

    public long getLength() {
        return -1L;
    }

    public void noteOn() {
        this.noteOn = true;
        this.noteOff = false;
        this.noteOnTime = this.currentTimeMS;
    }

    public void noteOff() {
        this.noteOff = true;
        this.noteOffTime = this.currentTimeMS;
    }

    public boolean isNoteOn() {
        return this.noteOn;
    }

    public void applyADSREnvelope(SampleBuffer sb) {
        double currentms = this.currentTimeMS - this.noteOnTime;
        double sampleTime = 1.0 / sb.getFormat().getSampleRateKHz();
        for (int i = 0; i < sb.size(); ++i) {
            if (this.noteOff && this.currentADSRValue == 0.0f && this.envelopePhase == 'R') {
                this.noteOn = false;
                this.fireSynthQuiet();
                this.noteOff = false;
            }
            if (currentms > (double)this.attack) {
                if (currentms > (double)(this.decay + this.attack)) {
                    if (!this.noteOff) {
                        this.currentADSRValue = this.sustain;
                        this.envelopePhase = (char)83;
                    } else {
                        this.currentADSRValue = this.sustain * Math.max(0.0f, (float)(1.0 - (currentms - this.noteOffTime) / (double)this.release));
                        this.envelopePhase = (char)82;
                    }
                } else {
                    this.currentADSRValue = Math.max(this.sustain, 1.0f - (float)((double)(1.0f - this.sustain) * (currentms - (double)this.attack) / (double)this.decay));
                    this.envelopePhase = (char)68;
                }
            } else {
                this.currentADSRValue = Math.min(1.0f, (float)(currentms / (double)this.attack));
                this.envelopePhase = (char)65;
            }
            sb.set(i, sb.get(i) * this.currentADSRValue);
            currentms += sampleTime;
        }
    }

    public char getEnvelopePhase() {
        return this.envelopePhase;
    }

    public long getAttack() {
        return this.attack;
    }

    public void setAttack(long attack) {
        this.attack = attack;
    }

    public long getDecay() {
        return this.decay;
    }

    public void setDecay(long decay) {
        this.decay = decay;
    }

    public float getSustain() {
        return this.sustain;
    }

    public void setSustain(float sustain) {
        this.sustain = sustain;
    }

    public long getRelease() {
        return this.release;
    }

    public void setRelease(long release) {
        this.release = release;
    }

    public void addSynthesizerListener(SynthesizerListener sl) {
        this.listeners.add(sl);
    }

    public void removeSynthesizerListener(SynthesizerListener sl) {
        this.listeners.remove(sl);
    }

    protected void fireSynthQuiet() {
        ArrayList<SynthesizerListener> l = new ArrayList<SynthesizerListener>(this.listeners);
        for (SynthesizerListener sl : l) {
            sl.synthQuiet();
        }
    }

    @Override
    public void noteOn(int noteNumber, double velocity) {
        System.out.println("Note on " + noteNumber);
        this.setGain((int)(velocity * 2.147483647E9));
        this.setFrequency(WesternScaleNote.noteToFrequency((int)noteNumber));
        this.noteOn();
    }

    @Override
    public void noteOff(int noteNumber) {
        System.out.println("Note off " + noteNumber);
        this.noteOff();
    }

    public static class FMOptions
    implements OscillatorOptions {
        public Synthesizer carrier;
        public Synthesizer modulator;
        public double modulatorAmplitude = 4.656612875245797E-7;
    }

    public static interface OscillatorOptions {
    }
}

