/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.generation;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.generation.Synthesizer;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;

public interface Oscillator {
    public SampleChunk getSampleChunk(int var1, double var2, double var4, int var6, AudioFormat var7);

    public Synthesizer.OscillatorOptions getOptions();

    public static class FrequencyModulatedOscillator
    implements Oscillator {
        private final Synthesizer.FMOptions options = new Synthesizer.FMOptions();

        @Override
        public SampleChunk getSampleChunk(int length, double time, double freq, int gain, AudioFormat format) {
            SampleBuffer sb = this.getOptions().modulator.nextSampleChunk().getSampleBuffer();
            double minTime = time;
            double maxTime = time + (double)length;
            double step = format.getSampleRateKHz();
            double amp = this.getOptions().modulatorAmplitude;
            for (int i = 0; i < sb.size(); ++i) {
                float f = sb.get(i);
                double t = time + step * (double)i + (double)f * amp;
                minTime = Math.min(t, minTime);
                maxTime = Math.max(t, maxTime);
            }
            int cl = (int)(maxTime - minTime);
            double ct = minTime;
            SampleBuffer carrierBuffer = this.getOptions().carrier.getOscillator().getSampleChunk(cl, ct, freq, gain, format).getSampleBuffer();
            for (int i = 0; i < sb.size(); ++i) {
                float f = sb.get(i);
                double t = time + step * (double)i + (double)f * amp;
                int index = (int)((t - minTime) / step);
                sb.set(i, carrierBuffer.get(index));
            }
            return sb.getSampleChunk();
        }

        @Override
        public Synthesizer.FMOptions getOptions() {
            return this.options;
        }
    }

    public static class DummyOscillator
    implements Oscillator {
        @Override
        public SampleChunk getSampleChunk(int length, double time, double freq, int gain, AudioFormat format) {
            SampleBuffer sb = SampleBufferFactory.createSampleBuffer((AudioFormat)format, (int)length);
            return sb.getSampleChunk();
        }

        @Override
        public Synthesizer.OscillatorOptions getOptions() {
            return null;
        }
    }

    public static class NoiseOscillator
    implements Oscillator {
        @Override
        public SampleChunk getSampleChunk(int length, double time, double freq, int gain, AudioFormat format) {
            SampleBuffer sb = SampleBufferFactory.createSampleBuffer((AudioFormat)format, (int)length);
            for (int i = 0; i < sb.size(); ++i) {
                sb.set(i, (float)(Math.random() * 2.147483647E9));
            }
            return sb.getSampleChunk();
        }

        @Override
        public Synthesizer.OscillatorOptions getOptions() {
            return null;
        }
    }

    public static class SawOscillator
    implements Oscillator {
        @Override
        public SampleChunk getSampleChunk(int length, double time, double freq, int gain, AudioFormat format) {
            SampleBuffer sb = SampleBufferFactory.createSampleBuffer((AudioFormat)format, (int)length);
            double samplesPerWave = format.getSampleRateKHz() * 1000.0 / freq;
            int p = (int)(samplesPerWave * (freq * time - Math.floor(freq * time)));
            for (int i = 0; i < length; ++i) {
                int x = (i + p) % (int)samplesPerWave;
                sb.set(i, (float)((double)x * ((double)gain / samplesPerWave)));
            }
            return sb.getSampleChunk();
        }

        @Override
        public Synthesizer.OscillatorOptions getOptions() {
            return null;
        }
    }

    public static class SquareOscillator
    implements Oscillator {
        @Override
        public SampleChunk getSampleChunk(int length, double time, double freq, int gain, AudioFormat format) {
            SampleBuffer sb = SampleBufferFactory.createSampleBuffer((AudioFormat)format, (int)length);
            double samplesPerWave = format.getSampleRateKHz() * 1000.0 / freq;
            int p = (int)(samplesPerWave * (freq * time - Math.floor(freq * time)));
            for (int i = 0; i < length; ++i) {
                int x = (i + p) % (int)samplesPerWave;
                if ((double)x > samplesPerWave / 2.0) {
                    sb.set(i, (float)gain);
                    continue;
                }
                sb.set(i, (float)(-gain));
            }
            return sb.getSampleChunk();
        }

        @Override
        public Synthesizer.OscillatorOptions getOptions() {
            return null;
        }
    }

    public static class SineOscillator
    implements Oscillator {
        @Override
        public SampleChunk getSampleChunk(int length, double time, double freq, int gain, AudioFormat format) {
            double samplesPerWave = format.getSampleRateKHz() * 1000.0 / freq;
            double p = Math.PI * 2 * (freq * time - Math.floor(freq * time));
            SampleBuffer sb = SampleBufferFactory.createSampleBuffer((AudioFormat)format, (int)length);
            double z = Math.PI * 2 / samplesPerWave;
            for (int i = 0; i < length; ++i) {
                sb.set(i, (float)(Math.sin((double)i * z + p) * (double)gain));
            }
            return sb.getSampleChunk();
        }

        @Override
        public Synthesizer.OscillatorOptions getOptions() {
            return null;
        }
    }
}

