/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.filters.TriangularFilter;
import org.openimaj.audio.util.AudioUtils;

public class MelFilterBank {
    private double lowestFreq = 300.0;
    private double highestFreq = 5000.0;
    private int nFilters = 40;
    private ArrayList<TriangularFilter> filters = null;

    public MelFilterBank() {
    }

    public MelFilterBank(int nFilters, double lowFreq, double highFreq) {
        this.lowestFreq = lowFreq;
        this.highestFreq = highFreq;
        this.nFilters = nFilters;
    }

    public void createFilterBank() {
        if (this.filters == null) {
            this.filters = new ArrayList();
            double lowFreqMel = AudioUtils.frequencyToMelFrequency((double)this.lowestFreq);
            double highFreqMel = AudioUtils.frequencyToMelFrequency((double)this.highestFreq);
            double melFreqRange = highFreqMel - lowFreqMel;
            double melFreqPerFilter = 2.0 * melFreqRange / (double)(this.nFilters + 1);
            for (int filter = 0; filter < this.nFilters; ++filter) {
                double lf = lowFreqMel + melFreqPerFilter / 2.0 * (double)filter;
                double cf = lf + melFreqPerFilter / 2.0;
                double hf = lf + melFreqPerFilter;
                this.filters.add(new TriangularFilter(AudioUtils.melFrequencyToFrequency((double)lf), AudioUtils.melFrequencyToFrequency((double)cf), AudioUtils.melFrequencyToFrequency((double)hf)));
            }
        }
    }

    public List<TriangularFilter> getFilters() {
        this.createFilterBank();
        return this.filters;
    }

    public float[][] process(float[][] spectrum, AudioFormat format) {
        this.createFilterBank();
        float[][] output = new float[spectrum.length][this.filters.size()];
        for (int c = 0; c < spectrum.length; ++c) {
            for (int i = 0; i < this.filters.size(); ++i) {
                output[c][i] = (float)this.filters.get(i).process(spectrum[c], format);
            }
        }
        return output;
    }

    public float[] getResponseCurve(int nSpectrumBins, double maxFreq) {
        float[][] curve = new float[1][nSpectrumBins];
        for (int i = 0; i < nSpectrumBins; ++i) {
            curve[0][i] = 1.0f;
        }
        return this.process(curve, new AudioFormat(8, maxFreq / 500.0, 1))[0];
    }

    public void setFilterAmplitude(double fa) {
        if (this.filters != null) {
            for (TriangularFilter mf : this.filters) {
                mf.setFilterAmplitude(fa);
            }
        }
    }

    public Matrix asMatrix(int specSize, double minFreq, double maxFreq) {
        if (this.filters == null) {
            return null;
        }
        Matrix m = new Matrix(this.filters.size(), specSize);
        double binSize = (maxFreq - minFreq) / (double)specSize;
        for (int filter = 0; filter < this.filters.size(); ++filter) {
            for (int i = 0; i < specSize; ++i) {
                m.set(filter, i, this.filters.get(filter).getWeightAt((double)i * binSize));
            }
        }
        return m;
    }
}

