/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.FixedSizeSampleAudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;

public class FeedForwardCombFilter
extends FixedSizeSampleAudioProcessor {
    private SampleBuffer buffer = null;
    private double gain = 1.0;
    private double outputPower = 0.0;
    private double inputPower = 0.0;
    private double frequency = 0.0;

    public FeedForwardCombFilter(int nSamplesDelay, double gain) {
        super(nSamplesDelay);
        this.gain = gain;
        this.frequency = -1.0;
    }

    public FeedForwardCombFilter(double frequency, double sampleRate, double gain) {
        this((int)(sampleRate / frequency), gain);
        this.frequency = frequency;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        if (this.buffer == null) {
            this.buffer = sample.getSampleBuffer();
            return sample;
        }
        this.buffer = sample.clone().getSampleBuffer();
        double p = 0.0;
        double ip = 0.0;
        SampleBuffer b = sample.getSampleBuffer();
        for (int i = 0; i < b.size(); ++i) {
            float d = (float)((double)b.get(i) - this.gain * (double)this.buffer.get(i));
            p += (double)(d * d);
            ip += (double)(b.get(i) * b.get(i));
            b.set(i, d);
        }
        this.outputPower = p;
        this.inputPower = ip;
        return sample;
    }

    public double getOutputPower() {
        return this.outputPower;
    }

    public double getInputPower() {
        return this.inputPower;
    }

    public double getHarmonicity() {
        return this.getOutputPower() / (this.getInputPower() * 4.0);
    }
}

