/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis.benchmarking;

import java.util.List;
import java.util.ListIterator;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.data.dataset.ListDataset;

public class AudioDatasetHelper {
    public static AudioStream getAudioStream(final ListDataset<List<SampleBuffer>> samples) {
        long streamLength = -1L;
        return new AudioStream(){
            private int index = 0;
            private List<SampleBuffer> l = null;
            private int listIndex = 0;
            private long timecodeOffset = 0L;
            private long currentTimecode = 0L;

            public void reset() {
                this.listIndex = 0;
                this.l = null;
                this.index = 0;
                this.timecodeOffset = 0L;
                this.currentTimecode = 0L;
            }

            public SampleChunk nextSampleChunk() {
                if (this.listIndex >= samples.size()) {
                    return null;
                }
                if (this.l == null || this.index >= this.l.size()) {
                    this.l = (List)samples.get(this.listIndex);
                    this.index = 0;
                    ++this.listIndex;
                    this.timecodeOffset += this.currentTimecode;
                }
                SampleChunk sc = this.l.get(this.index).getSampleChunk();
                this.currentTimecode = (long)((double)sc.getStartTimecode().getTimecodeInMilliseconds() + (double)sc.getNumberOfSamples() / sc.getFormat().getSampleRateKHz());
                sc.getStartTimecode().setTimecodeInMilliseconds(sc.getStartTimecode().getTimecodeInMilliseconds() + this.timecodeOffset);
                ++this.index;
                return sc;
            }

            public long getLength() {
                return -1L;
            }

            public AudioFormat getFormat() {
                SampleChunk sc = this.nextSampleChunk();
                this.reset();
                return sc.getFormat();
            }
        };
    }

    public static long calculateStreamLength(ListDataset<List<SampleBuffer>> samples) {
        ListIterator i = samples.listIterator();
        long length = 0L;
        while (i.hasNext()) {
            List l = (List)i.next();
            for (SampleBuffer sb : l) {
                length = (long)((double)length + (double)(sb.size() / sb.getFormat().getNumChannels()) * sb.getFormat().getSampleRateKHz());
            }
        }
        return length;
    }
}

