/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.analysis;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.FixedSizeSampleAudioProcessor;

public class EffectiveSoundPressure
extends FixedSizeSampleAudioProcessor {
    private double rms = 0.0;

    public EffectiveSoundPressure() {
        super(1);
    }

    public EffectiveSoundPressure(int windowSizeSamples, int overlapSamples) {
        super(windowSizeSamples);
        this.setWindowStep(overlapSamples);
    }

    public EffectiveSoundPressure(AudioStream stream, int windowSizeMillis, int overlapMillis) {
        super(stream, (int)(stream.getFormat().getSampleRateKHz() * (double)windowSizeMillis * (double)stream.getFormat().getNumChannels()));
        this.setWindowStep((int)(stream.getFormat().getSampleRateKHz() * (double)overlapMillis * (double)stream.getFormat().getNumChannels()));
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        int size;
        long accum = 0L;
        switch (sample.getFormat().getNBits()) {
            case 16: {
                ShortBuffer b = sample.getSamplesAsByteBuffer().asShortBuffer();
                size = b.limit();
                for (int x = 0; x < size; ++x) {
                    accum += (long)(b.get(x) * b.get(x));
                }
                break;
            }
            case 8: {
                ByteBuffer b = sample.getSamplesAsByteBuffer();
                size = b.limit();
                for (int x = 0; x < size; ++x) {
                    accum += (long)(b.get(x) * b.get(x));
                }
                break;
            }
            default: {
                throw new Exception("Unsupported Format");
            }
        }
        this.rms = Math.sqrt((double)accum / (double)size);
        return sample;
    }

    public double getEffectiveSoundPressure() {
        return this.rms;
    }
}

