/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.processor.FixedSizeSampleAudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;
import org.openimaj.audio.timecode.AudioTimecode;

public class AudioMixer
extends AudioStream {
    private final List<AudioStream> streams = new ArrayList<AudioStream>();
    private final List<Float> gain = new ArrayList<Float>();
    private final Map<AudioStream, AudioStream> streamMap = new HashMap<AudioStream, AudioStream>();
    private SampleBuffer currentSample = null;
    private int bufferSize = 256;
    private boolean alwaysRun = true;
    private long startMillis = -1L;
    private AudioTimecode timecode = null;
    private final List<MixEventListener> mixEventListeners = new ArrayList<MixEventListener>();
    private boolean fireMixEvents = false;

    public AudioMixer(AudioFormat af) {
        this.setFormat(af);
        this.currentSample = SampleBufferFactory.createSampleBuffer((AudioFormat)af, (int)this.bufferSize);
        this.timecode = new AudioTimecode(0L);
    }

    public void setTimecodeObject(AudioTimecode tc) {
        this.timecode = tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(AudioStream as, float defaultGain) {
        if (as.format.equals((Object)this.getFormat())) {
            AudioStream stream = as;
            if (stream.getClass().getName().equals(FixedSizeSampleAudioProcessor.class.getName())) {
                stream = ((AudioProcessor)as).getUnderlyingStream();
            }
            this.gain.add(Float.valueOf(defaultGain));
            List<AudioStream> list = this.streams;
            synchronized (list) {
                FixedSizeSampleAudioProcessor fssap = new FixedSizeSampleAudioProcessor(stream, this.bufferSize);
                this.streams.add((AudioStream)fssap);
                this.streamMap.put(as, (AudioStream)fssap);
            }
        } else {
            throw new IllegalArgumentException("Format of added stream is incompatible with the mixer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SampleChunk nextSampleChunk() {
        if (this.streams.size() == 0 && !this.alwaysRun) {
            return null;
        }
        if (this.startMillis == -1L) {
            this.startMillis = System.currentTimeMillis();
        }
        SampleBuffer sb = this.currentSample;
        SampleChunk sc = null;
        ArrayList<SampleBuffer> chunkList = new ArrayList<SampleBuffer>();
        List<AudioStream> list = this.streams;
        synchronized (list) {
            for (int stream = 0; stream < this.streams.size(); ++stream) {
                sc = this.streams.get(stream).nextSampleChunk();
                if (sc != null) {
                    chunkList.add(sc.getSampleBuffer());
                    continue;
                }
                this.streams.remove(stream);
                this.gain.remove(stream);
            }
            for (int i = 0; i < sb.size(); ++i) {
                float Z = 0.0f;
                for (int stream = 0; stream < chunkList.size(); ++stream) {
                    if (chunkList.get(stream) == null) continue;
                    Z += ((SampleBuffer)chunkList.get(stream)).get(i) * this.gain.get(stream).floatValue();
                }
                sb.set(i, Z);
            }
        }
        if (this.fireMixEvents) {
            for (MixEventListener mel : this.mixEventListeners) {
                mel.mix(chunkList.toArray(new SampleBuffer[0]), sb);
            }
        }
        sc = sb.getSampleChunk();
        this.timecode.setTimecodeInMilliseconds(System.currentTimeMillis() - this.startMillis);
        sc.setStartTimecode(this.timecode);
        return sc;
    }

    public void reset() {
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentSample = SampleBufferFactory.createSampleBuffer((AudioFormat)this.format, (int)bufferSize);
    }

    public void setAlwaysRun(boolean alwaysRun) {
        this.alwaysRun = alwaysRun;
    }

    public void addMixEventListener(MixEventListener mel) {
        this.mixEventListeners.add(mel);
    }

    public void removeMixEventListener(MixEventListener mel) {
        this.mixEventListeners.remove(mel);
    }

    public long getLength() {
        return -1L;
    }

    public void setMixEvents(boolean tf) {
        this.fireMixEvents = tf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(AudioStream as) {
        List<AudioStream> list = this.streams;
        synchronized (list) {
            AudioStream aas = this.streamMap.get(as);
            if (aas == null) {
                aas = as;
            }
            System.out.println("Removing " + aas + " from " + this.streams);
            this.gain.remove(this.streams.indexOf(aas));
            this.streams.remove(this.streams.indexOf(aas));
        }
    }

    public static interface MixEventListener {
        public void mix(SampleBuffer[] var1, SampleBuffer var2);
    }
}

