/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.stats;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.FlickrRuntimeException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.stats.Csv;
import com.flickr4java.flickr.stats.Domain;
import com.flickr4java.flickr.stats.DomainList;
import com.flickr4java.flickr.stats.Referrer;
import com.flickr4java.flickr.stats.ReferrerList;
import com.flickr4java.flickr.stats.Stats;
import com.flickr4java.flickr.stats.StatsSort;
import com.flickr4java.flickr.stats.Totals;
import com.flickr4java.flickr.util.XMLUtilities;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatsInterface {
    private static Logger _log = Logger.getLogger(StatsInterface.class);
    private static final String METHOD_GET_COLLECTION_DOMAINS = "flickr.stats.getCollectionDomains";
    private static final String METHOD_GET_COLLECTION_REFERRERS = "flickr.stats.getCollectionReferrers";
    private static final String METHOD_GET_COLLECTION_STATS = "flickr.stats.getCollectionStats";
    private static final String METHOD_GET_CSV_FILES = "flickr.stats.getCSVFiles";
    private static final String METHOD_GET_PHOTO_DOMAINS = "flickr.stats.getPhotoDomains";
    private static final String METHOD_GET_PHOTO_REFERRERS = "flickr.stats.getPhotoReferrers";
    private static final String METHOD_GET_PHOTO_STATS = "flickr.stats.getPhotoStats";
    private static final String METHOD_GET_PHOTOSET_DOMAINS = "flickr.stats.getPhotosetDomains";
    private static final String METHOD_GET_PHOTOSET_REFERRERS = "flickr.stats.getPhotosetReferrers";
    private static final String METHOD_GET_PHOTOSET_STATS = "flickr.stats.getPhotosetStats";
    private static final String METHOD_GET_PHOTOSTREAM_DOMAINS = "flickr.stats.getPhotostreamDomains";
    private static final String METHOD_GET_PHOTOSTREAM_REFERRERS = "flickr.stats.getPhotostreamReferrers";
    private static final String METHOD_GET_PHOTOSTREAM_STATS = "flickr.stats.getPhotostreamStats";
    private static final String METHOD_GET_POPULAR_PHOTOS = "flickr.stats.getPopularPhotos";
    private static final String METHOD_GET_TOTAL_VIEWS = "flickr.stats.getTotalViews";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public StatsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public DomainList getCollectionDomains(Date date, String collectionId, int perPage, int page) throws FlickrException {
        return this.getDomains(METHOD_GET_COLLECTION_DOMAINS, "collection_id", collectionId, date, perPage, page);
    }

    public ReferrerList getCollectionReferrers(Date date, String domain, String collectionId, int perPage, int page) throws FlickrException {
        return this.getReferrers(METHOD_GET_COLLECTION_REFERRERS, domain, "collection_id", collectionId, date, perPage, page);
    }

    public Stats getCollectionStats(String collectionId, Date date) throws FlickrException {
        return this.getStats(METHOD_GET_COLLECTION_STATS, "collection_id", collectionId, date);
    }

    public List<Csv> getCSVFiles() throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CSV_FILES);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Csv> csvFiles = this.parseCsvFiles(response);
        return csvFiles;
    }

    public DomainList getPhotoDomains(Date date, String photoId, int perPage, int page) throws FlickrException {
        return this.getDomains(METHOD_GET_PHOTO_DOMAINS, "photo_id", photoId, date, perPage, page);
    }

    public ReferrerList getPhotoReferrers(Date date, String domain, String photoId, int perPage, int page) throws FlickrException {
        return this.getReferrers(METHOD_GET_PHOTO_REFERRERS, domain, "photo_id", photoId, date, perPage, page);
    }

    public Stats getPhotoStats(String photoId, Date date) throws FlickrException {
        return this.getStats(METHOD_GET_PHOTO_STATS, "photo_id", photoId, date);
    }

    public DomainList getPhotosetDomains(Date date, String photosetId, int perPage, int page) throws FlickrException {
        return this.getDomains(METHOD_GET_PHOTOSET_DOMAINS, "photoset_id", photosetId, date, perPage, page);
    }

    public ReferrerList getPhotosetReferrers(Date date, String domain, String photosetId, int perPage, int page) throws FlickrException {
        return this.getReferrers(METHOD_GET_PHOTOSET_REFERRERS, domain, "photoset_id", photosetId, date, perPage, page);
    }

    public Stats getPhotosetStats(String photosetId, Date date) throws FlickrException {
        return this.getStats(METHOD_GET_PHOTOSET_STATS, "photoset_id", photosetId, date);
    }

    public DomainList getPhotostreamDomains(Date date, int perPage, int page) throws FlickrException {
        return this.getDomains(METHOD_GET_PHOTOSTREAM_DOMAINS, null, null, date, perPage, page);
    }

    public ReferrerList getPhotostreamReferrers(Date date, String domain, int perPage, int page) throws FlickrException {
        return this.getReferrers(METHOD_GET_PHOTOSTREAM_REFERRERS, domain, null, null, date, perPage, page);
    }

    public Stats getPhotostreamStats(Date date) throws FlickrException {
        return this.getStats(METHOD_GET_PHOTOSTREAM_STATS, null, null, date);
    }

    public PhotoList<Photo> getPopularPhotos(Date date, StatsSort sort, int perPage, int page) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_POPULAR_PHOTOS);
        if (date != null) {
            parameters.put("date", String.valueOf(date.getTime() / 1000L));
        }
        if (sort != null) {
            parameters.put("sort", sort.name());
        }
        this.addPaginationParameters(parameters, perPage, page);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        return this.parsePopularPhotos(response);
    }

    public Totals getTotalViews(Date date) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_TOTAL_VIEWS);
        if (date != null) {
            parameters.put("date", String.valueOf(date.getTime() / 1000L));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Totals totals = this.parseTotals(response);
        return totals;
    }

    private DomainList getDomains(String method, String idKey, String idValue, Date date, int perPage, int page) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", method);
        parameters.put("date", String.valueOf(date.getTime() / 1000L));
        if (idValue != null) {
            parameters.put(idKey, idValue);
        }
        this.addPaginationParameters(parameters, perPage, page);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        DomainList domains = this.parseDomains(response);
        return domains;
    }

    private DomainList parseDomains(Response response) {
        Element element = response.getPayload();
        DomainList domains = new DomainList();
        domains.setPage(element.getAttribute("page"));
        domains.setPages(element.getAttribute("pages"));
        domains.setPerPage(element.getAttribute("perpage"));
        domains.setTotal(element.getAttribute("total"));
        NodeList domainElements = element.getElementsByTagName("domain");
        for (int i = 0; i < domainElements.getLength(); ++i) {
            Element domainElement = (Element)domainElements.item(i);
            Domain domain = new Domain();
            domain.setName(domainElement.getAttribute("name"));
            domain.setViews(domainElement.getAttribute("views"));
            domains.add(domain);
        }
        return domains;
    }

    private ReferrerList getReferrers(String method, String domain, String idKey, String idValue, Date date, int perPage, int page) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", method);
        parameters.put("domain", domain);
        parameters.put("date", String.valueOf(date.getTime() / 1000L));
        if (idValue != null) {
            parameters.put(idKey, idValue);
        }
        this.addPaginationParameters(parameters, perPage, page);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ReferrerList referrers = this.parseReferrers(response);
        return referrers;
    }

    private ReferrerList parseReferrers(Response response) {
        Element element = response.getPayload();
        ReferrerList referrers = new ReferrerList();
        referrers.setPage(element.getAttribute("page"));
        referrers.setPages(element.getAttribute("pages"));
        referrers.setPerPage(element.getAttribute("perpage"));
        referrers.setTotal(element.getAttribute("total"));
        referrers.setName(element.getAttribute("name"));
        NodeList referrerElements = element.getElementsByTagName("referrer");
        for (int i = 0; i < referrerElements.getLength(); ++i) {
            Element referrerElement = (Element)referrerElements.item(i);
            Referrer referrer = new Referrer();
            referrer.setUrl(referrerElement.getAttribute("url"));
            referrer.setViews(referrerElement.getAttribute("views"));
            referrers.add(referrer);
        }
        return referrers;
    }

    private Stats getStats(String method, String idKey, String idValue, Date date) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", method);
        parameters.put("date", String.valueOf(date.getTime() / 1000L));
        if (idValue != null) {
            parameters.put(idKey, idValue);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Stats stats = this.parseStats(response.getPayload());
        return stats;
    }

    private Stats parseStats(Element element) {
        Stats stats = new Stats();
        String views = element.getAttribute("views");
        String comments = element.getAttribute("comments");
        String favorites = element.getAttribute("favorites");
        stats.setViews(views);
        stats.setComments(comments);
        stats.setFavorites(favorites);
        return stats;
    }

    private Totals parseTotals(Response response) {
        Element element = response.getPayload();
        Totals stats = new Totals();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String sets;
            String collections;
            String photostream;
            String photos;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String total = this.getViewsValue(childElement, "total");
            if (total != null) {
                stats.setTotal(total);
            }
            if ((photos = this.getViewsValue(childElement, "photos")) != null) {
                stats.setPhotos(photos);
            }
            if ((photostream = this.getViewsValue(childElement, "photostream")) != null) {
                stats.setPhotostream(photostream);
            }
            if ((collections = this.getViewsValue(childElement, "collections")) != null) {
                stats.setCollections(collections);
            }
            if ((sets = this.getViewsValue(childElement, "sets")) == null) continue;
            stats.setSets(sets);
        }
        return stats;
    }

    private String getViewsValue(Element childElement, String name) {
        String total = null;
        if (childElement.getNodeName().equals(name)) {
            total = childElement.getAttribute("views");
        }
        return total;
    }

    private void addPaginationParameters(Map<String, Object> parameters, int perPage, int page) {
        if (perPage > 0) {
            parameters.put("per_page", String.valueOf(perPage));
        }
        if (page > 0) {
            parameters.put("page", String.valueOf(page));
        }
    }

    private List<Csv> parseCsvFiles(Response response) {
        Element element = response.getPayload();
        ArrayList<Csv> csvFiles = new ArrayList<Csv>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        NodeList csvElements = element.getElementsByTagName("csv");
        for (int i = 0; i < csvElements.getLength(); ++i) {
            Element csvElement = (Element)csvElements.item(i);
            Csv csv = new Csv();
            csv.setHref(csvElement.getAttribute("href"));
            csv.setType(csvElement.getAttribute("type"));
            try {
                csv.setDate(dateFormat.parse(csvElement.getAttribute("date")));
            }
            catch (ParseException e) {
                throw new FlickrRuntimeException(e);
            }
            csvFiles.add(csv);
        }
        return csvFiles;
    }

    private PhotoList<Photo> parsePopularPhotos(Response response) {
        Element payload = response.getPayload();
        PhotoList<Photo> photos = new PhotoList<Photo>();
        NodeList photoElements = payload.getElementsByTagName("photo");
        for (int i = 0; i < photoElements.getLength(); ++i) {
            Element photoElement = (Element)photoElements.item(i);
            Photo photo = PhotoUtils.createPhoto(photoElement);
            Element statsElement = XMLUtilities.getChild(photoElement, "stats");
            Stats stats = this.parseStats(statsElement);
            photo.setStats(stats);
            photos.add(photo);
        }
        return photos;
    }
}

