/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.feature.local.keypoints.KeypointLocation;

public class MinMaxKeypoint
extends Keypoint {
    private static final long serialVersionUID = 1L;
    public boolean isMaxima;

    public MinMaxKeypoint() {
    }

    public MinMaxKeypoint(float x, float y, float ori, float scale, byte[] ivec, boolean isMaxima) {
        super(x, y, ori, scale, ivec);
        this.isMaxima = isMaxima;
    }

    public MinMaxKeypoint(int length) {
        super(length);
    }

    @Override
    public MinMaxKeypointLocation getLocation() {
        return new MinMaxKeypointLocation(this.x, this.y, this.ori, this.scale, this.isMaxima);
    }

    @Override
    public void setLocation(KeypointLocation location) {
        super.setLocation(location);
        if (location instanceof MinMaxKeypointLocation) {
            this.isMaxima = ((MinMaxKeypointLocation)location).isMaxima;
        }
    }

    public static class MinMaxKeypointLocation
    extends KeypointLocation {
        private static final long serialVersionUID = 1L;
        public boolean isMaxima;

        public MinMaxKeypointLocation(float x, float y, float ori, float scale, boolean isMaxima) {
            super(x, y, ori, scale);
            this.isMaxima = isMaxima;
        }

        @Override
        public void writeBinary(DataOutput out) throws IOException {
            out.writeFloat(this.x);
            out.writeFloat(this.y);
            out.writeFloat(this.scale);
            out.writeFloat(this.orientation);
            out.writeBoolean(this.isMaxima);
        }

        @Override
        public void writeASCII(PrintWriter out) throws IOException {
            out.format("%4.2f %4.2f %4.2f %4.3f %d", Float.valueOf(this.y), Float.valueOf(this.x), Float.valueOf(this.scale), Float.valueOf(this.orientation), this.isMaxima ? 1 : 0);
            out.println();
        }

        @Override
        public void readBinary(DataInput in) throws IOException {
            super.readBinary(in);
            this.isMaxima = in.readBoolean();
        }

        @Override
        public void readASCII(Scanner in) throws IOException {
            super.readASCII(in);
            this.isMaxima = in.nextInt() == 1;
        }
    }
}

