/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Circle;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Shape;

public class KeypointVisualizer<T, Q extends Image<T, Q>> {
    Q image;
    List<? extends Keypoint> keypoints;

    public KeypointVisualizer(Q image, List<? extends Keypoint> keys) {
        this.image = image;
        this.keypoints = keys;
    }

    public Map<Keypoint, Q> getPatches(int dim) {
        HashMap<Keypoint, Image> patches = new HashMap<Keypoint, Image>();
        HashMap<Float, Image> blurred = new HashMap<Float, Image>();
        for (Keypoint keypoint : this.keypoints) {
            if (!blurred.containsKey(Float.valueOf(keypoint.scale))) {
                blurred.put(Float.valueOf(keypoint.scale), ((SinglebandImageProcessor.Processable)this.image).process((SinglebandImageProcessor)new FGaussianConvolve(keypoint.scale)));
            }
            Image blur = (Image)blurred.get(Float.valueOf(keypoint.scale));
            int sz = (int)(12.0f * keypoint.scale);
            Image patch = this.image.newInstance(sz, sz);
            for (int y = 0; y < sz; ++y) {
                for (int x = 0; x < sz; ++x) {
                    double xbar = (double)x - (double)sz / 2.0;
                    double ybar = (double)y - (double)sz / 2.0;
                    double xx = xbar * Math.cos(-keypoint.ori) + ybar * Math.sin(-keypoint.ori) + (double)keypoint.x;
                    double yy = -xbar * Math.sin(-keypoint.ori) + ybar * Math.cos(-keypoint.ori) + (double)keypoint.y;
                    patch.setPixel(x, y, blur.getPixelInterp(xx, yy));
                }
            }
            patches.put(keypoint, ((SinglebandImageProcessor.Processable)patch).processInplace((SinglebandImageProcessor)new ResizeProcessor((float)dim, (float)dim)));
        }
        return patches;
    }

    public Q drawPatches(T boxColour, T circleColour) {
        return (Q)KeypointVisualizer.drawPatchesInplace(this.image.clone(), this.keypoints, boxColour, circleColour);
    }

    public static <T, Q extends Image<T, Q>> Q drawPatchesInplace(Q image, List<? extends Keypoint> keypoints, T boxColour, T circleColour) {
        ImageRenderer renderer = image.createRenderer();
        for (Keypoint keypoint : keypoints) {
            if (boxColour != null) {
                renderer.drawPolygon(KeypointVisualizer.getSamplingBox(keypoint), boxColour);
            }
            if (circleColour == null) continue;
            renderer.drawLine((int)keypoint.x, (int)keypoint.y, (double)(-keypoint.ori), (int)keypoint.scale * 5, circleColour);
            renderer.drawShape((Shape)new Circle(keypoint.x, keypoint.y, keypoint.scale), circleColour);
        }
        return image;
    }

    public Q drawCenter(T col) {
        Image output = this.image.clone();
        ImageRenderer renderer = output.createRenderer();
        renderer.drawPoints(this.keypoints, col, 2);
        return (Q)output;
    }

    public static Polygon getSamplingBox(Keypoint k) {
        return KeypointVisualizer.getSamplingBox(k, 0.0f);
    }

    public static Polygon getSamplingBox(Keypoint k, float scincr) {
        ArrayList<Point2dImpl> vertices = new ArrayList<Point2dImpl>();
        vertices.add(new Point2dImpl(k.x - (scincr + 6.0f * k.scale), k.y - (scincr + 6.0f * k.scale)));
        vertices.add(new Point2dImpl(k.x + (scincr + 6.0f * k.scale), k.y - (scincr + 6.0f * k.scale)));
        vertices.add(new Point2dImpl(k.x + (scincr + 6.0f * k.scale), k.y + (scincr + 6.0f * k.scale)));
        vertices.add(new Point2dImpl(k.x - (scincr + 6.0f * k.scale), k.y + (scincr + 6.0f * k.scale)));
        Polygon poly = new Polygon(vertices);
        poly.rotate((Point2d)new Point2dImpl(k.x, k.y), (double)(-k.ori));
        return poly;
    }
}

