/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest.experiment;

import Jama.Matrix;
import cern.colt.Arrays;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.feature.local.interest.EllipticInterestPointData;
import org.openimaj.image.feature.local.interest.experiment.IPDRepeatability;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class RepeatabilityExperiment {
    private IPDRepeatability<EllipticInterestPointData> rep;

    RepeatabilityExperiment(MBFImage img1, MBFImage img2, List<Ellipse> e1, List<Ellipse> e2, Matrix transform, double d) {
        this.rep = IPDRepeatability.repeatability(img1, img2, e1, e2, transform, d);
    }

    public double[] doExperiment() {
        return new double[]{this.rep.repeatability(0.5)};
    }

    public static void main(String[] args) {
        int centerx = 200;
        int centery = 200;
        Ellipse e1 = new Ellipse((double)centerx, (double)centery, 30.0, 20.0, 0.7853981633974483);
        Polygon e1Box = e1.calculateOrientedBoundingBox();
        MBFImage e1Image = new MBFImage(400, 400, ColourSpace.RGB);
        MBFImage e2Image = new MBFImage(400, 400, ColourSpace.RGB);
        e1Image.drawShape((Shape)e1, (Object)RGBColour.RED);
        e1Image.drawShape((Shape)e1Box, (Object)RGBColour.BLUE);
        Matrix rot = TransformUtilities.rotationMatrixAboutPoint((double)1.5707963267948966, (float)centerx, (float)centery);
        Matrix scale = TransformUtilities.scaleMatrixAboutPoint((double)2.0, (double)3.0, (int)centerx, (int)centery);
        Matrix move = TransformUtilities.translateMatrix((double)100.0, (double)100.0);
        Matrix transform = Matrix.identity((int)3, (int)3);
        transform = transform.times(move);
        transform = transform.times(scale);
        transform = transform.times(rot);
        Point2d e2Pos = e1.transform(transform).calculateCentroid();
        e2Image.drawPoint(e2Pos, (Object)RGBColour.GREEN, 3);
        Matrix mrot = TransformUtilities.rotationMatrixAboutPoint((double)0.4, (float)((int)e2Pos.getX()), (float)((int)e2Pos.getY()));
        Matrix mscale = TransformUtilities.scaleMatrixAboutPoint((double)1.02, (double)1.01, (int)((int)e2Pos.getX()), (int)((int)e2Pos.getY()));
        Matrix mmove = TransformUtilities.translateMatrix((double)-2.0, (double)-2.0);
        Matrix pert = Matrix.identity((int)3, (int)3);
        pert = pert.times(mmove);
        pert = pert.times(mrot);
        pert = pert.times(mscale);
        e2Image.drawShape((Shape)e1Box.transform(pert.times(transform)), (Object)RGBColour.BLUE);
        e2Image.drawShape(e1.transform(pert.times(transform)), (Object)RGBColour.RED);
        e2Image.drawShape((Shape)e1Box.transform(transform), (Object)RGBColour.GREEN);
        e2Image.drawShape(e1.transform(transform), (Object)RGBColour.ORANGE);
        Shape e2Untransform = e1.transform(pert.times(transform)).transform(transform.inverse());
        e1Image.drawShape(e2Untransform, (Object)RGBColour.GREEN);
        e1Image.drawPoint(e2Untransform.calculateCentroid(), (Object)RGBColour.GREEN, 3);
        ArrayList<Ellipse> e1List = new ArrayList<Ellipse>();
        e1List.add(e1);
        ArrayList<Ellipse> e2List = new ArrayList<Ellipse>();
        e2List.add(e1.transformAffine(pert.times(transform)));
        RepeatabilityExperiment exp = new RepeatabilityExperiment(e1Image, e2Image, e1List, e2List, transform, 1.0);
        System.out.println(Arrays.toString((double[])exp.doExperiment()));
        DisplayUtilities.display((Image)e1Image, (String)"Untransformed image");
        JFrame w2 = DisplayUtilities.display((Image)e2Image, (String)"Transformed image");
        w2.setBounds(400, 0, 400, 400);
    }
}

