/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;
import org.openimaj.algorithm.iterative.IterationState;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.matrix.PseudoInverse;
import org.openimaj.util.function.Predicate;

public class SubPixelCorners {
    private static final float[] GRAD_X_KERNEL = new float[]{-1.0f, 0.0f, 1.0f};
    private static final float[] GRAD_Y_KERNEL = new float[]{0.0f, 0.5f, 0.0f};
    private Predicate<IterationState> iter;
    private int halfWidth;
    private int halfHeight;
    private int zeroZoneHalfWidth = -1;
    private int zeroZoneHalfHeight = -1;

    public SubPixelCorners(int halfWidth, int halfHeight, Predicate<IterationState> iter) {
        this.halfWidth = halfWidth;
        this.halfHeight = halfHeight;
        this.iter = iter;
    }

    public SubPixelCorners(int halfWidth, int halfHeight, int zeroZoneHalfWidth, int zeroZoneHalfHeight, Predicate<IterationState> iter) {
        this.halfWidth = halfWidth;
        this.halfHeight = halfHeight;
        this.zeroZoneHalfWidth = zeroZoneHalfWidth;
        this.zeroZoneHalfHeight = zeroZoneHalfHeight;
        this.iter = iter;
    }

    public List<Point2dImpl> findSubPixCorners(FImage src, List<? extends Point2d> corners) {
        ArrayList<Point2dImpl> outCorners = new ArrayList<Point2dImpl>(corners.size());
        int windowWidth = this.halfWidth * 2 + 1;
        int windowHeight = this.halfHeight * 2 + 1;
        if (corners.size() == 0) {
            return outCorners;
        }
        FImage weights = this.buildGaussianWeights(windowWidth, windowHeight);
        FImage gx = new FImage(windowWidth, windowHeight);
        FImage gy = new FImage(windowWidth, windowHeight);
        float[] buffer = new float[windowWidth + 2];
        FImage roi = new FImage(windowWidth + 2, windowHeight + 2);
        for (int i = 0; i < corners.size(); ++i) {
            Point2d pt = corners.get(i);
            outCorners.add(this.findCornerSubPix(src, pt, roi, gx, gy, weights, buffer));
        }
        return outCorners;
    }

    public Point2dImpl findSubPixCorner(FImage src, Point2d corner) {
        int windowWidth = this.halfWidth * 2 + 1;
        int windowHeight = this.halfHeight * 2 + 1;
        FImage weights = this.buildGaussianWeights(windowWidth, windowHeight);
        FImage gx = new FImage(windowWidth, windowHeight);
        FImage gy = new FImage(windowWidth, windowHeight);
        float[] buffer = new float[windowWidth + 2];
        FImage roi = new FImage(windowWidth + 2, windowHeight + 2);
        return this.findCornerSubPix(src, corner, roi, gx, gy, weights, buffer);
    }

    private FImage buildGaussianWeights(int width, int height) {
        int j;
        int i;
        float[] weightsY;
        FImage weights = new FImage(width, height);
        float[] weightsX = new float[width];
        double coeff = 1.0 / (double)(this.halfWidth * this.halfWidth);
        int i2 = -this.halfWidth;
        int k = 0;
        while (i2 <= this.halfWidth) {
            weightsX[k] = (float)Math.exp((double)(-i2 * i2) * coeff);
            ++i2;
            ++k;
        }
        if (this.halfWidth == this.halfHeight) {
            weightsY = weightsX;
        } else {
            weightsY = new float[height];
            coeff = 1.0 / (double)(this.halfHeight * this.halfHeight);
            i = -this.halfHeight;
            int k2 = 0;
            while (i <= this.halfHeight) {
                weightsY[k2] = (float)Math.exp((double)(-i * i) * coeff);
                ++i;
                ++k2;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                weights.pixels[i][j] = weightsX[j] * weightsY[i];
            }
        }
        if (this.zeroZoneHalfWidth >= 0 && this.zeroZoneHalfHeight >= 0 && this.zeroZoneHalfWidth * 2 + 1 < width && this.zeroZoneHalfHeight * 2 + 1 < height) {
            for (i = this.halfHeight - this.zeroZoneHalfHeight; i <= this.halfHeight + this.zeroZoneHalfHeight; ++i) {
                for (j = this.halfWidth - this.zeroZoneHalfWidth; j <= this.halfWidth + this.zeroZoneHalfWidth; ++j) {
                    weights.pixels[i][j] = 0.0f;
                }
            }
        }
        return weights;
    }

    private Point2dImpl findCornerSubPix(FImage src, Point2d pt, FImage roi, FImage gx, FImage gy, FImage weights, float[] buffer) {
        IterationState state = new IterationState();
        Point2dImpl current = new Point2dImpl(pt);
        while (!this.iter.test((Object)state)) {
            src.extractCentreSubPix((Point2d)current, (Image)roi);
            FImageConvolveSeparable.fastConvolve3((FImage)roi, (FImage)gx, (float[])GRAD_X_KERNEL, (float[])GRAD_Y_KERNEL, (float[])buffer);
            FImageConvolveSeparable.fastConvolve3((FImage)roi, (FImage)gy, (float[])GRAD_Y_KERNEL, (float[])GRAD_X_KERNEL, (float[])buffer);
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            double bb1 = 0.0;
            double bb2 = 0.0;
            int win_w = weights.width;
            int win_h = weights.height;
            for (int i = 0; i < win_h; ++i) {
                double py = i - this.halfHeight;
                for (int j = 0; j < win_w; ++j) {
                    double m = weights.pixels[i][j];
                    double tgx = gx.pixels[i][j];
                    double tgy = gy.pixels[i][j];
                    double gxx = tgx * tgx * m;
                    double gxy = tgx * tgy * m;
                    double gyy = tgy * tgy * m;
                    double px = j - this.halfWidth;
                    a += gxx;
                    b += gxy;
                    c += gyy;
                    bb1 += gxx * px + gxy * py;
                    bb2 += gxy * px + gyy * py;
                }
            }
            Matrix m = new Matrix((double[][])new double[][]{{a, b}, {b, c}});
            Matrix mInv = PseudoInverse.pseudoInverse((Matrix)m);
            Point2dImpl cI2 = new Point2dImpl();
            cI2.x = (float)((double)current.x + mInv.get(0, 0) * bb1 + mInv.get(0, 1) * bb2);
            cI2.y = (float)((double)current.y + mInv.get(1, 0) * bb1 + mInv.get(1, 1) * bb2);
            state.epsilon = FastMath.sqrt((double)((cI2.x - current.x) * (cI2.x - current.x) + (cI2.y - current.y) * (cI2.y - current.y)));
            ++state.iteration;
            current = cI2;
        }
        if (Math.abs(current.x - pt.getX()) > (float)this.halfWidth || Math.abs(current.y - pt.getY()) > (float)this.halfHeight) {
            return new Point2dImpl(pt);
        }
        return current;
    }
}

