/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.keypoints.InterestPointKeypoint;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.Shape;

public class InterestPointVisualiser<T, Q extends Image<T, Q>> {
    Q image;
    List<Ellipse> interestPoints;

    public InterestPointVisualiser(Q image, List<Ellipse> keys) {
        this.image = image;
        this.interestPoints = keys;
    }

    public static <T, Q extends Image<T, Q>> InterestPointVisualiser<T, Q> visualiseKeypoints(Q image, List<? extends InterestPointKeypoint<? extends InterestPointData>> keys) {
        ArrayList<Ellipse> interestPoints = new ArrayList<Ellipse>();
        for (InterestPointKeypoint<? extends InterestPointData> interestPointKeypoint : keys) {
            interestPoints.add(((InterestPointData)((Object)interestPointKeypoint.location)).getEllipse());
        }
        return new InterestPointVisualiser<T, Q>(image, interestPoints);
    }

    public static <T, Q extends Image<T, Q>> InterestPointVisualiser<T, Q> visualiseInterestPoints(Q image, List<? extends InterestPointData> keys) {
        ArrayList<Ellipse> interestPoints = new ArrayList<Ellipse>();
        for (InterestPointData interestPointData : keys) {
            interestPoints.add(interestPointData.getEllipse());
        }
        return new InterestPointVisualiser<T, Q>(image, interestPoints);
    }

    public static <T, Q extends Image<T, Q>> InterestPointVisualiser<T, Q> visualiseInterestPoints(Q image, List<? extends InterestPointData> keys, double scale) {
        ArrayList<Ellipse> interestPoints = new ArrayList<Ellipse>();
        for (InterestPointData interestPointData : keys) {
            interestPoints.add(interestPointData.getEllipse());
        }
        return new InterestPointVisualiser<T, Q>(image, interestPoints);
    }

    public Q drawPatches(T pointCol, T borderCol) {
        Image output = this.image.clone();
        ImageRenderer renderer = output.createRenderer();
        for (Ellipse k : this.interestPoints) {
            if (pointCol != null) {
                renderer.drawPoint(k.calculateCentroid(), pointCol, 3);
            }
            if (borderCol == null) continue;
            renderer.drawShape((Shape)k, borderCol);
        }
        return (Q)output;
    }

    public Q drawCenter(T col) {
        Image output = this.image.clone();
        ImageRenderer renderer = output.createRenderer();
        for (Ellipse e : this.interestPoints) {
            renderer.drawPoint(e.calculateCentroid(), col, 2);
        }
        return (Q)output;
    }
}

