/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.interest;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.MultiscaleInterestPointDetector;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.convolution.BasicDerivativeKernels;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.util.FloatArrayStatsUtils;

public abstract class AbstractStructureTensorIPD
implements MultiscaleInterestPointDetector<InterestPointData> {
    protected int borderSkip;
    FImage originalImage;
    FImage l;
    FImage lx;
    FImage ly;
    FImage lxmx;
    FImage lymy;
    FImage lxmy;
    public FImage lxmxblur;
    public FImage lymyblur;
    public FImage lxmyblur;
    protected float detectionScale;
    protected float integrationScale;
    protected float detIntScaleFactor = 1.4f;
    protected List<Maxima> maxima;
    private boolean blurred;

    public AbstractStructureTensorIPD(float detIntScaleFactor) {
        this.detIntScaleFactor = detIntScaleFactor;
        this.borderSkip = 2;
    }

    public AbstractStructureTensorIPD(float detectionScale, float integrationScale) {
        this(detectionScale, integrationScale, 2, false);
    }

    public AbstractStructureTensorIPD(float detectionScale, float integrationScale, boolean blurred) {
        this(detectionScale, integrationScale, 2, blurred);
    }

    public AbstractStructureTensorIPD(float detectionScale, float integrationScale, int borderSkip) {
        this(detectionScale, integrationScale, borderSkip, false);
    }

    public AbstractStructureTensorIPD(float detectionScale, float integrationScale, int borderSkip, boolean blurred) {
        this.blurred = blurred;
        if (borderSkip < 1) {
            borderSkip = 1;
        }
        this.detectionScale = detectionScale;
        this.integrationScale = integrationScale;
        this.borderSkip = borderSkip;
    }

    public void prepareInterestPoints(FImage image) {
        this.originalImage = image;
        this.l = image;
        if (!this.blurred) {
            this.l = (FImage)this.l.processInplace((SinglebandImageProcessor)new FGaussianConvolve(this.detectionScale));
        }
        this.lx = ((FImage)this.l.process((SinglebandImageProcessor)BasicDerivativeKernels.DX_KERNEL)).multiplyInplace(this.detectionScale);
        this.ly = ((FImage)this.l.process((SinglebandImageProcessor)BasicDerivativeKernels.DY_KERNEL)).multiplyInplace(this.detectionScale);
        this.lxmx = (FImage)this.lx.multiply((Image)this.lx);
        this.lymy = (FImage)this.ly.multiply((Image)this.ly);
        this.lxmy = (FImage)this.lx.multiply((Image)this.ly);
        FGaussianConvolve intConv = new FGaussianConvolve(this.integrationScale);
        this.lxmxblur = (FImage)this.lxmx.clone().processInplace((SinglebandImageProcessor)intConv);
        this.lymyblur = (FImage)this.lymy.clone().processInplace((SinglebandImageProcessor)intConv);
        this.lxmyblur = (FImage)this.lxmy.clone().processInplace((SinglebandImageProcessor)intConv);
    }

    public void printStructureTensorStats() {
        System.out.format("Structure tensor stats for sd/si = %4.2f/%4.2f\n", Float.valueOf(this.detectionScale), Float.valueOf(this.integrationScale));
        System.out.format("\tlxmx mean/std = %4.2e/%4.2e max/min = %4.2e/%4.2e\n", Float.valueOf(FloatArrayStatsUtils.mean((float[][])this.lxmxblur.pixels)), Float.valueOf(FloatArrayStatsUtils.std((float[][])this.lxmxblur.pixels)), this.lxmx.max(), this.lxmx.min());
        System.out.format("\tlxmy mean/std = %4.2e/%4.2e max/min = %4.2e/%4.2e\n", Float.valueOf(FloatArrayStatsUtils.mean((float[][])this.lxmyblur.pixels)), Float.valueOf(FloatArrayStatsUtils.std((float[][])this.lxmyblur.pixels)), this.lxmy.max(), this.lxmy.min());
        System.out.format("\tlymy mean/std = %4.2e/%4.2e max/min = %4.2e/%4.2e\n", Float.valueOf(FloatArrayStatsUtils.mean((float[][])this.lymyblur.pixels)), Float.valueOf(FloatArrayStatsUtils.std((float[][])this.lymyblur.pixels)), this.lymy.max(), this.lymy.min());
    }

    @Override
    public void findInterestPoints(FImage image) {
        this.prepareInterestPoints(image);
        FImage cornerImage = this.createInterestPointMap();
        this.detectMaxima(cornerImage, image.getBounds());
    }

    @Override
    public void findInterestPoints(FImage image, Rectangle window) {
        this.prepareInterestPoints(image);
        FImage cornerImage = this.createInterestPointMap();
        System.out.format("corner image mean/std = %4.2e/%4.2e max/min = %4.2e/%4.2e\n", Float.valueOf(FloatArrayStatsUtils.mean((float[][])cornerImage.pixels)), Float.valueOf(FloatArrayStatsUtils.std((float[][])cornerImage.pixels)), cornerImage.max(), cornerImage.min());
        this.detectMaxima(cornerImage, window);
    }

    public FValuePixel findMaximum(Rectangle window) {
        FImage cornerImage = this.createInterestPointMap();
        FValuePixel c = ((FImage)cornerImage.extractROI(window)).maxPixel();
        c.translate(window.x, window.y);
        return c;
    }

    protected void detectMaxima(FImage image, Rectangle window) {
        this.maxima = new ArrayList<Maxima>();
        for (int y = this.borderSkip; y < image.height - this.borderSkip; ++y) {
            for (int x = this.borderSkip; x < image.width - this.borderSkip; ++x) {
                float curr;
                if (!window.isInside((Point2d)new Pixel(x, y)) || !((curr = image.pixels[y][x]) > image.pixels[y - 1][x - 1]) || !(curr >= image.pixels[y - 1][x]) || !(curr >= image.pixels[y - 1][x + 1]) || !(curr >= image.pixels[y][x - 1]) || !(curr >= image.pixels[y][x + 1]) || !(curr >= image.pixels[y + 1][x - 1]) || !(curr >= image.pixels[y + 1][x]) || !(curr >= image.pixels[y + 1][x + 1])) continue;
                this.maxima.add(new Maxima(x, y, curr));
            }
        }
        Collections.sort(this.maxima, new Comparator<Maxima>(){

            @Override
            public int compare(Maxima o1, Maxima o2) {
                if (o1.val == o2.val) {
                    return 0;
                }
                return o1.val < o2.val ? 1 : -1;
            }
        });
    }

    public abstract FImage createInterestPointMap();

    @Override
    public List<InterestPointData> getInterestPoints(int npoints) {
        if (npoints < 0 || npoints > this.maxima.size()) {
            npoints = this.maxima.size();
        }
        ArrayList<InterestPointData> ipdata = new ArrayList<InterestPointData>();
        for (int i = 0; i < npoints; ++i) {
            InterestPointData ipd = new InterestPointData();
            ipd.x = this.maxima.get((int)i).x;
            ipd.y = this.maxima.get((int)i).y;
            ipd.scale = this.integrationScale;
            ipd.score = this.maxima.get((int)i).val;
            ipdata.add(ipd);
        }
        return ipdata;
    }

    public float getDetIntScaleFactor() {
        return this.detIntScaleFactor;
    }

    public void setDetIntScaleFactor(float detIntScaleFactor) {
        this.detIntScaleFactor = detIntScaleFactor;
    }

    public float getDetectionScale() {
        return this.detectionScale;
    }

    public void setImageBlurred(boolean blurred) {
        this.blurred = blurred;
    }

    @Override
    public void setDetectionScale(float detectionScale) {
        this.detectionScale = detectionScale;
        this.integrationScale = this.detectionScale * this.detIntScaleFactor;
    }

    public float getIntegrationScale() {
        return this.integrationScale;
    }

    public void setIntegrationScale(float integrationScale) {
        this.integrationScale = integrationScale;
        this.detectionScale = integrationScale * (1.0f / this.detIntScaleFactor);
    }

    @Override
    public List<InterestPointData> getInterestPoints() {
        return this.getInterestPoints(-1);
    }

    @Override
    public List<InterestPointData> getInterestPoints(float threshold) {
        return this.getInterestPointsThresh(threshold);
    }

    public List<InterestPointData> getInterestPointsThresh(float thresh) {
        ArrayList<InterestPointData> ipdata = new ArrayList<InterestPointData>();
        for (Maxima m : this.maxima) {
            if (m.val < thresh) continue;
            InterestPointData ipd = new InterestPointData();
            ipd.x = m.x;
            ipd.y = m.y;
            ipd.scale = this.integrationScale;
            ipd.score = m.val;
            ipdata.add(ipd);
        }
        return ipdata;
    }

    public Matrix getSecondMomentsAt(int x, int y) {
        Matrix secondMoments = new Matrix(2, 2);
        secondMoments.set(0, 0, (double)this.lxmxblur.pixels[y][x]);
        secondMoments.set(0, 1, (double)this.lxmyblur.pixels[y][x]);
        secondMoments.set(1, 0, (double)this.lxmyblur.pixels[y][x]);
        secondMoments.set(1, 1, (double)this.lymyblur.pixels[y][x]);
        return secondMoments;
    }

    public AbstractStructureTensorIPD clone() {
        AbstractStructureTensorIPD a = null;
        try {
            a = (AbstractStructureTensorIPD)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return a;
    }

    public int pointsFound() {
        return this.maxima.size();
    }

    public class Maxima {
        public int x;
        public int y;
        public float val;

        public Maxima(int x, int y, float v) {
            this.x = x;
            this.y = y;
            this.val = v;
        }
    }
}

