/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine.ipd;

import org.openimaj.image.feature.local.detector.ipd.finder.CharacteristicOctaveInterestPointFinder;
import org.openimaj.image.feature.local.detector.ipd.finder.LoggingOctaveInterestPointFinder;
import org.openimaj.image.feature.local.detector.ipd.finder.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.MultiscaleInterestPointDetector;

public interface FinderMode<T extends InterestPointData> {
    public OctaveInterestPointFinder<T> finder(MultiscaleInterestPointDetector<T> var1, IPDSelectionMode var2);

    public static class Characteristic<T extends InterestPointData>
    implements FinderMode<T> {
        private CharacteristicOctaveInterestPointFinder<T> settings = new CharacteristicOctaveInterestPointFinder(null, null);

        public Characteristic() {
        }

        public Characteristic(int maxDistance, double maxRotation, double maxAxisRatio) {
            this.settings.maxDistance = maxDistance;
            this.settings.maxRotation = maxRotation;
            this.settings.maxAxisRatio = maxAxisRatio;
        }

        public Characteristic(int maxDistance) {
            this.settings.maxDistance = maxDistance;
        }

        @Override
        public OctaveInterestPointFinder<T> finder(MultiscaleInterestPointDetector<T> detector, IPDSelectionMode selectionMode) {
            CharacteristicOctaveInterestPointFinder<T> n = new CharacteristicOctaveInterestPointFinder<T>(detector, selectionMode);
            n.maxDistance = this.settings.maxDistance;
            n.maxRotation = this.settings.maxRotation;
            n.maxAxisRatio = this.settings.maxAxisRatio;
            return n;
        }
    }

    public static class Logging<T extends InterestPointData>
    implements FinderMode<T> {
        @Override
        public OctaveInterestPointFinder<T> finder(MultiscaleInterestPointDetector<T> detector, IPDSelectionMode selectionMode) {
            return new LoggingOctaveInterestPointFinder<T>(detector, selectionMode);
        }
    }

    public static class Basic<T extends InterestPointData>
    implements FinderMode<T> {
        @Override
        public OctaveInterestPointFinder<T> finder(MultiscaleInterestPointDetector<T> detector, IPDSelectionMode selectionMode) {
            return new OctaveInterestPointFinder<T>(detector, selectionMode);
        }
    }
}

