/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine.ipd;

import java.util.List;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.descriptor.gradient.SIFTFeatureProvider;
import org.openimaj.image.feature.local.detector.dog.extractor.DominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.ipd.collector.InterestPointFeatureCollector;
import org.openimaj.image.feature.local.detector.ipd.extractor.InterestPointGradientFeatureExtractor;
import org.openimaj.image.feature.local.detector.ipd.finder.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.engine.ipd.FinderMode;
import org.openimaj.image.feature.local.interest.IPDSelectionMode;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.interest.MultiscaleInterestPointDetector;
import org.openimaj.image.feature.local.keypoints.InterestPointKeypoint;

public abstract class AbstractIPDSIFTEngine<T extends InterestPointData> {
    private static final boolean DEFAULT_ACROSS_SCALES = false;
    private static final IPDSelectionMode DEFAULT_SELECTION_MODE = new IPDSelectionMode.Threshold(2500.0f);
    private FinderMode<T> finderMode = new FinderMode.Basic();
    private MultiscaleInterestPointDetector<T> detector;
    private boolean acrossScales = false;
    private IPDSelectionMode selectionMode = DEFAULT_SELECTION_MODE;

    public void setSelectionMode(IPDSelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public AbstractIPDSIFTEngine(MultiscaleInterestPointDetector<T> detector) {
        this.detector = detector;
        this.selectionMode = DEFAULT_SELECTION_MODE;
    }

    public LocalFeatureList<InterestPointKeypoint<T>> findFeatures(FImage image) {
        InterestPointFeatureCollector<T> collector = this.constructCollector(new InterestPointGradientFeatureExtractor(new DominantOrientationExtractor(), new SIFTFeatureProvider()));
        image = image.multiply(Float.valueOf(255.0f));
        if (this.acrossScales) {
            this.findAcrossScales(image, collector);
        } else {
            this.findInSingleScale(image, collector);
        }
        return collector.getFeatures();
    }

    public abstract InterestPointFeatureCollector<T> constructCollector(InterestPointGradientFeatureExtractor var1);

    private void findInSingleScale(FImage image, InterestPointFeatureCollector<T> collector) {
        this.detector.findInterestPoints(image);
        List<T> points = this.selectionMode.selectPoints(this.detector);
        for (InterestPointData point : points) {
            collector.foundInterestPoint(image, point);
        }
    }

    private void findAcrossScales(FImage image, InterestPointFeatureCollector<T> collector) {
        OctaveInterestPointFinder<T> finder = this.constructFinder();
        finder.setOctaveInterestPointListener(collector);
        GaussianPyramidOptions options = new GaussianPyramidOptions();
        options.setDoubleInitialImage(false);
        options.setInitialSigma(1.0f);
        options.setExtraScaleSteps(0);
        options.setOctaveProcessor(finder);
        GaussianPyramid pyr = new GaussianPyramid(options);
        pyr.process((Image)image);
        finder.finish();
    }

    private OctaveInterestPointFinder<T> constructFinder() {
        return this.getFinderMode().finder(this.detector, this.selectionMode);
    }

    public void setAcrossScales(boolean acrossScales) {
        this.acrossScales = acrossScales;
    }

    public void setFinderMode(FinderMode<T> finderMode) {
        this.finderMode = finderMode;
    }

    public FinderMode<T> getFinderMode() {
        return this.finderMode;
    }
}

