/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.collector;

import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.feature.local.detector.dog.collector.AbstractOctaveLocalFeatureCollector;
import org.openimaj.image.feature.local.detector.dog.extractor.GradientFeatureExtractor;
import org.openimaj.image.feature.local.detector.dog.pyramid.DoGOctaveExtremaFinder;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;
import org.openimaj.image.feature.local.keypoints.MinMaxKeypoint;

public class OctaveMinMaxKeypointCollector
extends AbstractOctaveLocalFeatureCollector<GaussianOctave<FImage>, GradientFeatureExtractor, MinMaxKeypoint, FImage> {
    protected ScaleSpaceImageExtractorProperties<FImage> extractionProperties = new ScaleSpaceImageExtractorProperties();

    public OctaveMinMaxKeypointCollector(GradientFeatureExtractor featureExtractor) {
        super(featureExtractor);
    }

    @Override
    public void foundInterestPoint(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder, float x, float y, float octaveScale) {
        int currentScaleIndex = finder.getCurrentScaleIndex();
        this.extractionProperties.image = ((FImage[])finder.getOctave().images)[currentScaleIndex];
        this.extractionProperties.scale = octaveScale;
        this.extractionProperties.x = x;
        this.extractionProperties.y = y;
        float octSize = finder.getOctave().octaveSize;
        boolean isMaxima = (double)((FImage[])((DoGOctaveExtremaFinder)finder).getDoGOctave().images)[currentScaleIndex].pixels[Math.round(y)][Math.round(x)] > 0.0;
        this.addFeature(octSize * x, octSize * y, octSize * octaveScale, isMaxima);
    }

    protected void addFeature(float imx, float imy, float imscale, boolean isMaxima) {
        OrientedFeatureVector[] fvs;
        for (OrientedFeatureVector fv : fvs = ((GradientFeatureExtractor)this.featureExtractor).extractFeature(this.extractionProperties)) {
            this.features.add((Object)new MinMaxKeypoint(imx, imy, fv.orientation, imscale, (byte[])fv.values, isMaxima));
        }
    }
}

