/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.SpatialLocation;
import org.openimaj.image.feature.local.aggregate.SpatialVectorAggregator;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.concatenate.Concatenatable;

public class PyramidSpatialAggregator<T, AGGREGATE extends FeatureVector & Concatenatable<AGGREGATE, AGGREGATE>>
implements SpatialVectorAggregator<ArrayFeatureVector<T>, SpatialLocation, Rectangle> {
    protected VectorAggregator<ArrayFeatureVector<T>, AGGREGATE> innerAggregator;
    boolean[][][] levels;

    public PyramidSpatialAggregator(VectorAggregator<ArrayFeatureVector<T>, AGGREGATE> innerAggregator, String description) {
        this.innerAggregator = innerAggregator;
        this.levels = PyramidSpatialAggregator.parseLevelsSimple(description);
    }

    public PyramidSpatialAggregator(VectorAggregator<ArrayFeatureVector<T>, AGGREGATE> innerAggregator, int ... numBlocks) {
        this.innerAggregator = innerAggregator;
        this.levels = new boolean[numBlocks.length][][];
        for (int i = 0; i < numBlocks.length; ++i) {
            this.levels[i] = new boolean[numBlocks[i]][numBlocks[i]];
            for (int j = 0; j < numBlocks[i]; ++j) {
                Arrays.fill(this.levels[i][j], true);
            }
        }
    }

    private static boolean[][][] parseLevelsSimple(String simple) {
        String[] parts = simple.split("-");
        boolean[][][] levels = new boolean[parts.length][][];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String[] tmp = part.split("x");
            if (tmp.length != 2) {
                throw new IllegalArgumentException("Invalid specification string");
            }
            int binsX = Integer.parseInt(tmp[0]);
            int binsY = Integer.parseInt(tmp[1]);
            levels[i] = new boolean[binsY][binsX];
            for (int j = 0; j < binsY; ++j) {
                Arrays.fill(levels[i][j], true);
            }
        }
        return levels;
    }

    protected static boolean[][][] parseLevelsAdvanced(String description) {
        String[] parts = description.split("[+]");
        ArrayList<boolean[][]> levels = new ArrayList<boolean[][]>();
        for (int i = 0; i < parts.length; ++i) {
            ArrayList<String> levelDesc = new ArrayList<String>();
            levelDesc.add(parts[i]);
            String key = parts[i].substring(0, parts[i].indexOf("#") + 1);
            while (i < parts.length) {
                if (!parts[i].startsWith(key)) {
                    --i;
                    break;
                }
                levelDesc.add(parts[i]);
                ++i;
            }
            int x = Integer.parseInt(key.substring(1, key.indexOf("x")));
            int y = Integer.parseInt(key.substring(key.indexOf("x") + 1, key.indexOf("#")));
            boolean[][] level = new boolean[y][x];
            for (int yy = 0; yy < y; ++yy) {
                for (int xx = 0; xx < x; ++xx) {
                    String curr = key + (xx + yy * x);
                    level[yy][xx] = levelDesc.contains(curr);
                }
            }
            levels.add(level);
        }
        return (boolean[][][])levels.toArray((T[])new boolean[levels.size()][][]);
    }

    protected static String levelsToString(boolean[][][] levels) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < levels.length; ++i) {
            int y = levels[i].length;
            int x = levels[i][0].length;
            sb.append("Level " + i + " (" + x + "x" + y + "):\n");
            for (int yy = 0; yy < y; ++yy) {
                for (int xx = 0; xx < x; ++xx) {
                    sb.append(levels[i][yy][xx] ? "X" : "-");
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public AGGREGATE aggregate(List<? extends LocalFeature<? extends SpatialLocation, ? extends ArrayFeatureVector<T>>> features, Rectangle bounds) {
        ArrayList levelFeatures = new ArrayList(this.levels.length);
        for (int l = 0; l < this.levels.length; ++l) {
            void var12_14;
            boolean[][] level = this.levels[l];
            int blocksX = level[0].length;
            int blocksY = level.length;
            Object[][] spatialData = new Object[blocksY][blocksX];
            for (int y = 0; y < blocksY; ++y) {
                for (int x = 0; x < blocksX; ++x) {
                    if (!level[y][x]) continue;
                    spatialData[y][x] = new ArrayList();
                }
            }
            float stepX = (bounds.width - bounds.x) / (float)blocksX;
            float stepY = (bounds.height - bounds.y) / (float)blocksY;
            for (LocalFeature<SpatialLocation, ArrayFeatureVector<T>> localFeature : features) {
                SpatialLocation spatialLoc = (SpatialLocation)localFeature.getLocation();
                int xbin = (int)Math.floor((spatialLoc.x - bounds.x) / stepX);
                int ybin = (int)Math.floor((spatialLoc.y - bounds.y) / stepY);
                if (!level[ybin][xbin]) continue;
                ((List)spatialData[ybin][xbin]).add(localFeature);
            }
            ArrayList<AGGREGATE> spatialFeatures = new ArrayList<AGGREGATE>(blocksX * blocksY);
            boolean bl = false;
            while (var12_14 < blocksY) {
                for (int x = 0; x < blocksX; ++x) {
                    if (spatialData[var12_14][x] == null) continue;
                    AGGREGATE fv = this.innerAggregator.aggregate((List)spatialData[var12_14][x]);
                    spatialFeatures.add(fv);
                }
                ++var12_14;
            }
            levelFeatures.add(this.join(spatialFeatures));
        }
        return (AGGREGATE)this.join(levelFeatures);
    }

    private AGGREGATE join(List<AGGREGATE> fvs) {
        FeatureVector first = (FeatureVector)fvs.get(0);
        ArrayList<AGGREGATE> others = new ArrayList<AGGREGATE>(fvs.size() - 1);
        for (int i = 1; i < fvs.size(); ++i) {
            others.add(fvs.get(i));
        }
        return (AGGREGATE)((FeatureVector)((Concatenatable)first).concatenate(others));
    }
}

