/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.SpatialLocation;
import org.openimaj.image.feature.local.aggregate.SpatialVectorAggregator;
import org.openimaj.image.feature.local.aggregate.VectorAggregator;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.concatenate.Concatenatable;

public class BlockSpatialAggregator<T, AGGREGATE extends FeatureVector & Concatenatable<AGGREGATE, AGGREGATE>>
implements SpatialVectorAggregator<ArrayFeatureVector<T>, SpatialLocation, Rectangle> {
    protected VectorAggregator<ArrayFeatureVector<T>, AGGREGATE> innerAggregator;
    protected int blocksX;
    protected int blocksY;

    public BlockSpatialAggregator(VectorAggregator<ArrayFeatureVector<T>, AGGREGATE> innerAggregator, int blocksX, int blocksY) {
        this.innerAggregator = innerAggregator;
        this.blocksX = blocksX;
        this.blocksY = blocksY;
    }

    public AGGREGATE aggregate(List<? extends LocalFeature<? extends SpatialLocation, ? extends ArrayFeatureVector<T>>> features, Rectangle bounds) {
        ArrayList spatialFeatures = new ArrayList(this.blocksX * this.blocksY);
        for (int i = 0; i < this.blocksX * this.blocksY; ++i) {
            spatialFeatures.add(new ArrayList());
        }
        float stepX = (bounds.width - bounds.x) / (float)this.blocksX;
        float stepY = (bounds.height - bounds.y) / (float)this.blocksY;
        for (LocalFeature<SpatialLocation, ArrayFeatureVector<T>> localFeature : features) {
            SpatialLocation l = (SpatialLocation)localFeature.getLocation();
            int xbin = (int)Math.floor((l.x - bounds.x) / stepX);
            int ybin = (int)Math.floor((l.y - bounds.y) / stepY);
            int idx = xbin + this.blocksX * ybin;
            ((List)spatialFeatures.get(idx)).add(localFeature);
        }
        AGGREGATE first = this.innerAggregator.aggregate((List)spatialFeatures.get(0));
        ArrayList<AGGREGATE> arrayList = new ArrayList<AGGREGATE>(spatialFeatures.size() - 1);
        for (int i = 1; i < spatialFeatures.size(); ++i) {
            arrayList.add(this.innerAggregator.aggregate((List)spatialFeatures.get(i)));
        }
        return (AGGREGATE)((FeatureVector)((Concatenatable)first).concatenate(arrayList));
    }
}

