/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.affine;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.feature.local.keypoints.KeypointLocation;
import org.openimaj.image.processing.transform.AffineParams;

public class AffineSimulationKeypoint
extends Keypoint {
    private static final long serialVersionUID = 1L;
    public AffineParams affineParams = new AffineParams();
    public int index;

    public AffineSimulationKeypoint(int length) {
        super(length);
    }

    public AffineSimulationKeypoint(Keypoint k, AffineParams afParams, int index) {
        super(k);
        this.affineParams.theta = afParams.theta;
        this.affineParams.tilt = afParams.tilt;
        this.index = index;
    }

    @Override
    public AffineSimulationKeypointLocation getLocation() {
        return new AffineSimulationKeypointLocation(this.x, this.y, this.scale, this.ori, this.affineParams.theta, this.affineParams.tilt, this.index);
    }

    @Override
    public void setLocation(KeypointLocation location) {
        super.setLocation(location);
        this.affineParams = new AffineParams();
        this.affineParams.theta = ((AffineSimulationKeypointLocation)location).theta;
        this.affineParams.tilt = ((AffineSimulationKeypointLocation)location).tilt;
        this.index = ((AffineSimulationKeypointLocation)location).index;
    }

    @Override
    public Float getOrdinate(int dimension) {
        float[] pos = new float[]{this.x, this.y, this.scale, this.ori, this.affineParams.theta, this.affineParams.tilt, this.index};
        return Float.valueOf(pos[dimension]);
    }

    @Override
    public String toString() {
        return "AffineKeypoint(" + this.affineParams.theta + "," + this.affineParams.tilt + "," + super.toString() + ")";
    }

    public static class AffineSimulationKeypointLocation
    extends KeypointLocation {
        private static final long serialVersionUID = 1L;
        public float theta;
        public float tilt;
        public int index;

        public AffineSimulationKeypointLocation() {
        }

        public AffineSimulationKeypointLocation(float x, float y, float scale, float ori, float theta, float tilt, int index) {
            super(x, y, ori, scale);
            this.theta = theta;
            this.tilt = tilt;
            this.index = index;
        }

        @Override
        public void writeBinary(DataOutput out) throws IOException {
            out.writeFloat(this.x);
            out.writeFloat(this.y);
            out.writeFloat(this.scale);
            out.writeFloat(this.orientation);
            out.writeFloat(this.theta);
            out.writeFloat(this.tilt);
            out.writeInt(this.index);
        }

        @Override
        public void writeASCII(PrintWriter out) throws IOException {
            out.format("%4.2f %4.2f %4.2f %4.3f %4.3f %4.3f %d", Float.valueOf(this.y), Float.valueOf(this.x), Float.valueOf(this.scale), Float.valueOf(this.orientation), Float.valueOf(this.theta), Float.valueOf(this.tilt), this.index);
            out.println();
        }

        @Override
        public void readBinary(DataInput in) throws IOException {
            super.readBinary(in);
            this.theta = in.readFloat();
            this.tilt = in.readFloat();
            this.index = in.readInt();
        }

        @Override
        public void readASCII(Scanner in) throws IOException {
            super.readASCII(in);
            this.theta = in.nextFloat();
            this.tilt = in.nextFloat();
            String indexString = in.next();
            int dotIndex = indexString.indexOf(".");
            if (dotIndex != -1) {
                indexString = indexString.substring(0, dotIndex);
            }
            this.index = Integer.parseInt(indexString);
        }

        @Override
        public Float getOrdinate(int dimension) {
            float[] pos = new float[]{this.x, this.y, this.scale, this.orientation, this.theta, this.tilt, this.index};
            return Float.valueOf(pos[dimension]);
        }
    }
}

