/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.affine;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.Image;
import org.openimaj.image.feature.local.affine.AffineSimulationExtractor;
import org.openimaj.image.feature.local.engine.DoGSIFTEngineOptions;
import org.openimaj.image.feature.local.engine.Engine;
import org.openimaj.image.feature.local.keypoints.Keypoint;

@Reference(type=ReferenceType.Article, author={"Morel, Jean-Michel", "Yu, Guoshen"}, title="{ASIFT: A New Framework for Fully Affine Invariant Image Comparison}", year="2009", journal="SIAM J. Img. Sci.", publisher="Society for Industrial and Applied Mathematics")
public abstract class ASIFT<I extends Image<P, I>, P>
extends AffineSimulationExtractor<LocalFeatureList<Keypoint>, Keypoint, I, P> {
    Engine<Keypoint, I> keypointEngine;

    public ASIFT(boolean hires) {
        DoGSIFTEngineOptions opts = new DoGSIFTEngineOptions();
        opts.setDoubleInitialImage(hires);
        this.keypointEngine = this.constructEngine(opts);
    }

    public ASIFT(DoGSIFTEngineOptions<I> opts) {
        this.keypointEngine = this.constructEngine(opts);
    }

    public abstract Engine<Keypoint, I> constructEngine(DoGSIFTEngineOptions<I> var1);

    @Override
    protected LocalFeatureList<Keypoint> newList() {
        return new MemoryLocalFeatureList();
    }

    @Override
    protected LocalFeatureList<Keypoint> detectFeatures(I image) {
        LocalFeatureList<Keypoint> keys = this.keypointEngine.findFeatures(image);
        return keys;
    }
}

