/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.local.matcher.FastBasicKeypointMatcher;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.util.pair.Pair;

public class FastLimitedBasicKeypointMatcher<T extends Keypoint>
extends FastBasicKeypointMatcher<T> {
    private int limit;

    public FastLimitedBasicKeypointMatcher(int threshold, int limit) {
        super(threshold);
        this.limit = limit;
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        this.matches = new ArrayList();
        byte[][] data = new byte[keys1.size()][];
        for (int i = 0; i < keys1.size(); ++i) {
            data[i] = ((Keypoint)keys1.get((int)i)).ivec;
        }
        int[][] argmins = new int[keys1.size()][2];
        float[][] mins = new float[keys1.size()][2];
        this.modelKeypointsKNN.searchKNN((byte[][])data, 2, argmins, mins);
        for (int i = 0; i < keys1.size(); ++i) {
            float distsq1 = mins[i][0];
            float distsq2 = mins[i][1];
            if (100.0f * distsq1 < (float)(this.thresh * this.thresh) * distsq2) {
                this.matches.add(new Pair(keys1.get(i), this.modelKeypoints.get(argmins[i][0])));
            }
            if (this.matches.size() >= this.limit) break;
        }
        return true;
    }
}

