/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.filter;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.ByteFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.util.function.Predicate;

@Reference(author={"Wei Dong", "Zhe Wang", "Kai Li"}, title="High-Confidence Near-Duplicate Image Detection", type=ReferenceType.Inproceedings, year="2012", booktitle="ACM International Conference on Multimedia Retrieval", customData={"location", "Hong Kong, China"})
public class ByteEntropyFilter
implements Predicate<LocalFeature<?, ByteFV>> {
    double threshold = 4.4;

    public ByteEntropyFilter() {
    }

    public ByteEntropyFilter(double threshold) {
        this.threshold = threshold;
    }

    public boolean test(LocalFeature<?, ByteFV> object) {
        return ByteEntropyFilter.entropy((byte[])((ByteFV)object.getFeatureVector()).values) >= this.threshold;
    }

    public static double entropy(byte[] vector) {
        int[] counts = new int[256];
        for (int i = 0; i < vector.length; ++i) {
            int n = vector[i] + 128;
            counts[n] = counts[n] + 1;
        }
        double log2 = Math.log(2.0);
        double entropy = 0.0;
        for (int b = 0; b < counts.length; ++b) {
            double p = (double)counts[b] / (double)vector.length;
            entropy -= p == 0.0 ? 0.0 : p * Math.log(p) / log2;
        }
        return entropy;
    }
}

