/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget;

import com.github.axet.vget.info.VideoInfo;
import com.github.axet.vget.info.VideoInfoUser;
import com.github.axet.wget.DirectMultipart;
import com.github.axet.wget.DirectRange;
import com.github.axet.wget.DirectSingle;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadIOCodeError;
import com.github.axet.wget.info.ex.DownloadIOError;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMultipartError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class VGet {
    VideoInfo info;
    File targetDir;
    File targetForce = null;
    File targetFile = null;

    public VGet(URL source) {
        this(new VideoInfo(source), null);
    }

    public VGet(URL source, File targetDir) {
        this(new VideoInfo(source), targetDir);
    }

    public VGet(VideoInfo info, File targetDir) {
        this.info = info;
        this.targetDir = targetDir;
    }

    public void setTarget(File file) {
        this.targetForce = file;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public File getTarget() {
        return this.targetFile;
    }

    public VideoInfo getVideo() {
        return this.info;
    }

    public void download() {
        this.download(new VideoInfoUser(), new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void download(VideoInfoUser user) {
        this.download(user, new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    static String replaceBadChars(String f) {
        String ff;
        String replace = " ";
        f = f.replaceAll("/", replace);
        f = f.replaceAll("\\\\", replace);
        f = f.replaceAll(":", replace);
        f = f.replaceAll("\\?", replace);
        f = f.replaceAll("\\\"", replace);
        f = f.replaceAll("\\*", replace);
        f = f.replaceAll("<", replace);
        f = f.replaceAll(">", replace);
        f = f.replaceAll("\\|", replace);
        f = f.trim();
        f = StringUtils.removeEnd((String)f, (String)".");
        f = f.trim();
        while (!(ff = f.replaceAll("  ", " ")).equals(f)) {
            f = ff;
        }
        return f;
    }

    static String maxFileNameLength(String str) {
        int max = 255;
        if (str.length() > max) {
            str = str.substring(0, max);
        }
        return str;
    }

    boolean done(AtomicBoolean stop) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DownloadInterruptedError("interrupted");
        }
        return false;
    }

    void retry(VideoInfoUser user, AtomicBoolean stop, Runnable notify, Throwable e) {
        boolean retracted = false;
        while (!retracted) {
            for (int i = 10; i >= 0; --i) {
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new DownloadInterruptedError("interrupted");
                }
                this.info.setDelay(i, e);
                notify.run();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ee) {
                    throw new DownloadInterruptedError((Throwable)ee);
                }
            }
            try {
                DownloadInfo infoOld = this.info.getInfo();
                this.info.extract(user, stop, notify);
                DownloadInfo infoNew = this.info.getInfo();
                if (infoOld != null && infoOld.resume(infoNew)) {
                    infoNew.copy(infoOld);
                } else if (this.targetFile != null) {
                    FileUtils.deleteQuietly((File)this.targetFile);
                    this.targetFile = null;
                }
                retracted = true;
            }
            catch (DownloadIOCodeError ee) {
                if (this.retry(ee)) {
                    this.info.setState(VideoInfo.States.RETRYING, ee);
                    notify.run();
                    continue;
                }
                throw ee;
            }
            catch (DownloadRetry ee) {
                this.info.setState(VideoInfo.States.RETRYING, ee);
                notify.run();
            }
        }
    }

    void target(DownloadInfo dinfo) {
        if (this.targetForce != null) {
            this.targetFile = this.targetForce;
            if (dinfo.multipart()) {
                if (!DirectMultipart.canResume((DownloadInfo)dinfo, (File)this.targetFile)) {
                    this.targetFile = null;
                }
            } else if (dinfo.getRange()) {
                if (!DirectRange.canResume((DownloadInfo)dinfo, (File)this.targetFile)) {
                    this.targetFile = null;
                }
            } else if (!DirectSingle.canResume((DownloadInfo)dinfo, (File)this.targetFile)) {
                this.targetFile = null;
            }
        }
        if (this.targetFile == null) {
            File f;
            Integer idupcount = 0;
            String sfilename = VGet.replaceBadChars(this.info.getTitle());
            sfilename = VGet.maxFileNameLength(sfilename);
            String ct = dinfo.getContentType();
            if (ct == null) {
                throw new DownloadRetry("null content type");
            }
            String ext = ct.replaceFirst("video/", "").replaceAll("x-", "");
            do {
                String add = idupcount > 0 ? " (".concat(idupcount.toString()).concat(")") : "";
                f = new File(this.targetDir, sfilename + add + "." + ext);
                idupcount = idupcount + 1;
            } while (f.exists());
            this.targetFile = f;
            dinfo.reset();
        }
    }

    boolean retry(Throwable e) {
        if (e == null) {
            return true;
        }
        if (e instanceof DownloadIOCodeError) {
            DownloadIOCodeError c = (DownloadIOCodeError)e;
            switch (c.getCode()) {
                case 403: 
                case 416: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean empty() {
        return this.getVideo().empty();
    }

    public void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void extract(AtomicBoolean stop, Runnable notify) {
        this.extract(new VideoInfoUser(), stop, notify);
    }

    public void extract(VideoInfoUser user, AtomicBoolean stop, Runnable notify) {
        while (!this.done(stop)) {
            try {
                if (this.info.empty()) {
                    this.info.setState(VideoInfo.States.EXTRACTING);
                    this.info.extract(user, stop, notify);
                    this.info.setState(VideoInfo.States.EXTRACTING_DONE);
                    notify.run();
                }
                return;
            }
            catch (DownloadRetry e) {
                this.retry(user, stop, notify, e);
            }
            catch (DownloadMultipartError e) {
                this.checkFileNotFound(e);
                this.checkRetry(e);
                this.retry(user, stop, notify, e);
            }
            catch (DownloadIOCodeError e) {
                if (this.retry(e)) {
                    this.retry(user, stop, notify, e);
                    continue;
                }
                throw e;
            }
            catch (DownloadIOError e) {
                this.retry(user, stop, notify, e);
            }
        }
    }

    void checkRetry(DownloadMultipartError e) {
        for (DownloadInfo.Part ee : e.getInfo().getParts()) {
            if (this.retry(ee.getException())) continue;
            throw e;
        }
    }

    void checkFileNotFound(DownloadMultipartError e) {
        FileNotFoundException f = null;
        for (DownloadInfo.Part ee : e.getInfo().getParts()) {
            if (ee.getException() == null) continue;
            if (ee.getException().getCause() == null) {
                return;
            }
            if (!(ee.getException().getCause() instanceof FileNotFoundException)) break;
            if (f == null) {
                f = (FileNotFoundException)ee.getException().getCause();
                continue;
            }
            FileNotFoundException ff = (FileNotFoundException)ee.getException().getCause();
            if (ff.getMessage().equals(f.getMessage())) continue;
            return;
        }
        if (f != null) {
            throw new DownloadError(f);
        }
    }

    public void download(AtomicBoolean stop, Runnable notify) {
        this.download(new VideoInfoUser(), stop, notify);
    }

    public void download(VideoInfoUser user, AtomicBoolean stop, final Runnable notify) {
        if (this.targetFile == null && this.targetForce == null && this.targetDir == null) {
            throw new RuntimeException("Set download file or directory first");
        }
        try {
            if (this.empty()) {
                this.extract(user, stop, notify);
            }
            while (!this.done(stop)) {
                try {
                    DirectMultipart direct;
                    final DownloadInfo dinfo = this.info.getInfo();
                    if (dinfo.getContentType() == null || !dinfo.getContentType().contains("video/")) {
                        throw new DownloadRetry("unable to download video, bad content");
                    }
                    this.target(dinfo);
                    if (dinfo.multipart()) {
                        direct = new DirectMultipart(dinfo, this.targetFile);
                    } else if (dinfo.getRange()) {
                        if (this.targetFile.exists() && this.targetFile.length() != dinfo.getCount()) {
                            this.targetFile = null;
                        }
                        direct = new DirectRange(dinfo, this.targetFile);
                    } else {
                        direct = new DirectSingle(dinfo, this.targetFile);
                    }
                    direct.download(stop, new Runnable(){

                        @Override
                        public void run() {
                            switch (dinfo.getState()) {
                                case DOWNLOADING: {
                                    VGet.this.info.setState(VideoInfo.States.DOWNLOADING);
                                    notify.run();
                                    break;
                                }
                                case RETRYING: {
                                    VGet.this.info.setDelay(dinfo.getDelay(), dinfo.getException());
                                    notify.run();
                                    break;
                                }
                            }
                        }
                    });
                    this.info.setState(VideoInfo.States.DONE);
                    notify.run();
                    return;
                }
                catch (DownloadRetry e) {
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadMultipartError e) {
                    this.checkFileNotFound(e);
                    this.checkRetry(e);
                    this.retry(user, stop, notify, e);
                }
                catch (DownloadIOCodeError e) {
                    if (this.retry(e)) {
                        this.retry(user, stop, notify, e);
                        continue;
                    }
                    throw e;
                }
                catch (DownloadIOError e) {
                    this.retry(user, stop, notify, e);
                }
            }
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(VideoInfo.States.STOP, e);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(VideoInfo.States.ERROR, e);
            notify.run();
            throw e;
        }
    }
}

