/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.FewEigenvalues;
import java.util.Iterator;
import org.openimaj.ml.clustering.spectral.EigenChooser;
import org.openimaj.util.pair.DoubleObjectPair;

public class ChangeDetectingEigenChooser
extends EigenChooser {
    private double relativeGap;
    private double maxSelect;

    public ChangeDetectingEigenChooser(double relativeGap, double maxSelect) {
        this.relativeGap = relativeGap;
        this.maxSelect = maxSelect;
    }

    @Override
    public int nEigenVectors(Iterator<DoubleObjectPair<Vector>> vals, int totalEigenVectors) {
        int maxCount;
        double val;
        int count = 0;
        double prevDiff = 0.0;
        double prevVal = vals.next().first;
        while (vals.hasNext() && !((val = vals.next().first) < 0.0)) {
            double l;
            double diff = Math.abs(val - prevVal);
            if (prevDiff != 0.0 && diff > (l = prevDiff * this.relativeGap)) {
                ++count;
                break;
            }
            prevDiff = diff;
            prevVal = val;
            ++count;
        }
        if (count > (maxCount = (int)((double)totalEigenVectors * this.maxSelect))) {
            return maxCount;
        }
        return count;
    }

    public FewEigenvalues prepare(SparseMatrix laplacian) {
        int total = laplacian.columnCount();
        FewEigenvalues eig = FewEigenvalues.of((Matrix)laplacian);
        return eig.greatest((int)((double)total * this.maxSelect));
    }
}

