/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.rforest;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

public class RandomDecision {
    public int threshold;
    public int feature;
    private int randomSeed = -1;
    private Random random = new Random();

    public RandomDecision(int featureLength, int[] minVal, int[] maxVal) {
        this.setFeatureDecision(featureLength, minVal, maxVal);
    }

    private void setFeatureDecision(int featureLength, int[] minVal, int[] maxVal) {
        this.feature = this.random.nextInt(featureLength);
        this.threshold = maxVal[this.feature] - minVal[this.feature] == 0 ? minVal[this.feature] : this.random.nextInt(maxVal[this.feature] - minVal[this.feature]) + minVal[this.feature];
    }

    public RandomDecision(int featureLength, int[] minVal, int[] maxVal, Random r) {
        this.random = r;
        this.setFeatureDecision(featureLength, minVal, maxVal);
    }

    public RandomDecision() {
    }

    public void write(DataOutput o) throws IOException {
        o.writeInt(this.threshold);
        o.writeInt(this.feature);
    }

    public void writeASCII(PrintWriter writer) {
        writer.print(this.threshold + "," + this.feature);
    }

    public RandomDecision readBinary(DataInput dis) throws IOException {
        this.threshold = dis.readInt();
        this.feature = dis.readInt();
        return this;
    }

    public RandomDecision readString(String line) {
        String[] bits = line.split(",");
        this.threshold = Integer.parseInt(bits[0]);
        this.feature = Integer.parseInt(bits[1]);
        return this;
    }

    public String toString() {
        String s = "(" + this.feature + "," + this.threshold + ")";
        return s;
    }

    public void setRandomSeed(int randomSeed) {
        this.randomSeed = randomSeed;
        this.random = new Random(this.randomSeed);
    }
}

