/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.meanshift;

import gnu.trove.procedure.TIntObjectProcedure;
import java.util.List;
import java.util.Set;
import org.openimaj.math.statistics.distribution.MultivariateKernelDensityEstimate;
import org.openimaj.util.pair.ObjectDoublePair;
import org.openimaj.util.set.DisjointSetForest;
import org.openimaj.util.tree.DoubleKDTree;

public class ExactMeanShift {
    private int maxIter = 300;
    private MultivariateKernelDensityEstimate kde;
    private int[] assignments;
    private double[][] modes;
    private int[] counts;

    public ExactMeanShift(MultivariateKernelDensityEstimate kde) {
        this.kde = kde;
        this.performMeanShift();
    }

    protected void performMeanShift() {
        double[][] data = this.kde.getData();
        double[][] modePerPoint = new double[data.length][];
        for (int i = 0; i < data.length; ++i) {
            double[] point = (double[])data[i].clone();
            for (int iter = 0; iter < this.maxIter && !this.computeMeanShift(point); ++iter) {
            }
            modePerPoint[i] = point;
        }
        this.mergeModes(modePerPoint);
    }

    public double[][] getModes() {
        return this.modes;
    }

    public int[] getAssignments() {
        return this.assignments;
    }

    protected void mergeModes(double[][] modePerPoint) {
        final DisjointSetForest forest = new DisjointSetForest();
        for (int i = 0; i < modePerPoint.length; ++i) {
            forest.makeSet((Object)modePerPoint[i]);
        }
        DoubleKDTree tree = new DoubleKDTree(modePerPoint);
        for (int i = 0; i < modePerPoint.length; ++i) {
            final double[] point = modePerPoint[i];
            tree.radiusSearch(modePerPoint[i], this.kde.getScaledBandwidth(), (TIntObjectProcedure)new TIntObjectProcedure<double[]>(){

                public boolean execute(int a, double[] b) {
                    forest.union((Object)point, (Object)b);
                    return true;
                }
            });
        }
        Set subsets = forest.getSubsets();
        this.assignments = new int[modePerPoint.length];
        this.modes = new double[subsets.size()][];
        this.counts = new int[subsets.size()];
        int current = 0;
        for (Set s : subsets) {
            this.modes[current] = new double[modePerPoint[0].length];
            for (int i = 0; i < modePerPoint.length; ++i) {
                if (!s.contains(modePerPoint[i])) continue;
                this.assignments[i] = current;
                for (int j = 0; j < this.modes[current].length; ++j) {
                    this.modes[current][j] = modePerPoint[i][j];
                }
            }
            this.counts[current] = s.size();
            int j = 0;
            while (j < this.modes[current].length) {
                double[] dArray = this.modes[current];
                int n = j++;
                dArray[n] = dArray[n] / (double)this.counts[current];
            }
            ++current;
        }
    }

    protected boolean computeMeanShift(double[] pt) {
        int j;
        List support = this.kde.getSupport(pt);
        if (support.size() == 1) {
            return true;
        }
        double sum = 0.0;
        double[] out = new double[pt.length];
        for (ObjectDoublePair p : support) {
            sum += p.second;
            for (j = 0; j < out.length; ++j) {
                int n = j;
                out[n] = out[n] + p.second * ((double[])p.first)[j];
            }
        }
        double dist = 0.0;
        for (j = 0; j < out.length; ++j) {
            int n = j;
            out[n] = out[n] / sum;
            dist += (pt[j] - out[j]) * (pt[j] - out[j]);
        }
        System.arraycopy(out, 0, pt, 0, out.length);
        return dist < 0.001 * this.kde.getBandwidth();
    }
}

