/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.incremental;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import java.util.List;
import java.util.Map;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SparseMatrixClusterer;
import org.openimaj.ml.clustering.incremental.IncrementalSparseClusterer;
import org.openimaj.util.pair.IntDoublePair;

public class IncrementalLifetimeSparseClusterer
extends IncrementalSparseClusterer {
    private int lifetime;
    private TIntIntHashMap seenCount;

    public IncrementalLifetimeSparseClusterer(SparseMatrixClusterer<? extends IndexClusters> clusterer, int window) {
        super(clusterer, window);
        this.lifetime = 3;
        this.seenCount = new TIntIntHashMap();
    }

    public IncrementalLifetimeSparseClusterer(SparseMatrixClusterer<? extends IndexClusters> clusterer, int window, int lifetime) {
        super(clusterer, window);
        this.lifetime = lifetime;
        this.seenCount = new TIntIntHashMap();
    }

    public IncrementalLifetimeSparseClusterer(SparseMatrixClusterer<? extends IndexClusters> clusterer, int window, double threshold, int lifetime) {
        super(clusterer, window, threshold);
        this.lifetime = lifetime;
        this.seenCount = new TIntIntHashMap();
    }

    @Override
    protected void detectInactive(IndexClusters oldClusters, IndexClusters newClusters, TIntSet inactiveRows, List<int[]> completedClusters) {
        Map<Integer, IntDoublePair> stability = this.calculateStability(oldClusters, newClusters, inactiveRows);
        for (Map.Entry<Integer, IntDoublePair> e : stability.entrySet()) {
            int index;
            int i;
            int[] completedCluster = oldClusters.clusters()[e.getKey()];
            if (e.getValue().second >= this.threshold) {
                for (i = 0; i < completedCluster.length; ++i) {
                    index = completedCluster[i];
                    inactiveRows.add(index);
                    this.seenCount.remove(index);
                }
                completedClusters.add(completedCluster);
                continue;
            }
            for (i = 0; i < completedCluster.length; ++i) {
                index = completedCluster[i];
                int newCount = this.seenCount.adjustOrPutValue(index, 1, 1);
                if (newCount < this.lifetime) continue;
                this.seenCount.remove(index);
                inactiveRows.add(index);
                completedClusters.add(new int[]{index});
            }
        }
    }
}

