/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.knn.IntNearestNeighbours;
import org.openimaj.knn.IntNearestNeighboursProvider;
import org.openimaj.knn.approximate.IntNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class KDTreeIntEuclideanAssigner
implements HardAssigner<int[], float[], IntFloatPair> {
    protected IntNearestNeighboursKDTree nn;

    public KDTreeIntEuclideanAssigner(CentroidsProvider<int[]> provider) {
        IntNearestNeighbours internal;
        if (provider instanceof IntNearestNeighboursProvider && (internal = ((IntNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof IntNearestNeighboursKDTree) {
            this.nn = (IntNearestNeighboursKDTree)internal;
            return;
        }
        this.nn = new IntNearestNeighboursKDTree((int[][])provider.getCentroids(), 8, 768);
    }

    public KDTreeIntEuclideanAssigner(int[][] data) {
        this.nn = new IntNearestNeighboursKDTree(data, 8, 768);
    }

    public int[] assign(int[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(int[] data) {
        return this.assign(new int[][]{data})[0];
    }

    public void assignDistance(int[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(int[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((int[][])new int[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

