/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.soft.HierarchicalLongPathAssigner;
import org.openimaj.ml.clustering.kmeans.HierarchicalLongKMeansResult;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.IntDoublePair;

public class HierarchicalLongHardAssigner
implements HardAssigner<long[], double[], IntDoublePair> {
    protected HierarchicalLongKMeansResult result;
    protected HierarchicalLongPathAssigner path;
    protected ScoringScheme scorer;

    public HierarchicalLongHardAssigner(HierarchicalLongKMeansResult result, ScoringScheme scorer) {
        this.result = result;
        this.scorer = scorer;
        this.path = new HierarchicalLongPathAssigner(result);
    }

    public HierarchicalLongHardAssigner(HierarchicalLongKMeansResult result) {
        this(result, ScoringScheme.SUM);
    }

    public int[] assign(long[][] data) {
        int[] asgn = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            asgn[i] = this.result.getIndex(this.path.assign(data[i]));
        }
        return asgn;
    }

    @Override
    public int assign(long[] data) {
        return this.result.getIndex(this.path.assign(data));
    }

    public void assignDistance(long[][] data, int[] indices, double[] distances) {
        int depth = this.result.getDepth();
        long[][] d = new long[1][];
        int[][] p = new int[1][depth];
        double[][] w = new double[1][depth];
        for (int i = 0; i < data.length; ++i) {
            d[0] = data[i];
            this.path.assignWeighted(d, p, w);
            indices[i] = this.result.getIndex(p[0]);
            distances[i] = this.scorer.computeScore(w[0]);
        }
    }

    @Override
    public IntDoublePair assignDistance(long[] data) {
        IndependentPair<int[], double[]> pw = this.path.assignWeighted(data);
        int index = this.result.getIndex((int[])pw.firstObject());
        double score = this.scorer.computeScore((double[])pw.secondObject());
        return new IntDoublePair(index, score);
    }

    @Override
    public int size() {
        return this.result.countLeafs();
    }

    @Override
    public int numDimensions() {
        return this.result.numDimensions();
    }

    public static enum ScoringScheme {
        SUM{

            @Override
            public double computeScore(double[] weights) {
                double sum = 0.0;
                for (double w : weights) {
                    if (w < 0.0) break;
                    sum += w;
                }
                return sum;
            }
        }
        ,
        PRODUCT{

            @Override
            public double computeScore(double[] weights) {
                double prod = 1.0;
                for (double w : weights) {
                    if (w < 0.0) break;
                    prod *= w;
                }
                return prod;
            }
        }
        ,
        FIRST{

            @Override
            public double computeScore(double[] weights) {
                return weights[0];
            }
        }
        ,
        LAST{

            @Override
            public double computeScore(double[] weights) {
                double last = -1.0;
                for (double w : weights) {
                    if (w < 0.0) break;
                    last = w;
                }
                return last;
            }
        }
        ,
        MEAN{

            @Override
            public double computeScore(double[] weights) {
                double sum = 0.0;
                int count = 0;
                for (double w : weights) {
                    if (w < 0.0) break;
                    sum += w;
                    ++count;
                }
                return sum / (double)count;
            }
        };


        protected abstract double computeScore(double[] var1);
    }
}

