/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.IntFVComparator;
import org.openimaj.knn.IntNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class ExactIntAssigner
implements HardAssigner<int[], float[], IntFloatPair> {
    protected IntNearestNeighboursExact nn;

    public ExactIntAssigner(CentroidsProvider<int[]> provider) {
        this(provider, null);
    }

    public ExactIntAssigner(CentroidsProvider<int[]> provider, IntFVComparator comparison) {
        this.nn = new IntNearestNeighboursExact((int[][])provider.getCentroids(), comparison);
    }

    public ExactIntAssigner(int[][] data, IntFVComparator comparison) {
        this.nn = new IntNearestNeighboursExact(data, comparison);
    }

    public int[] assign(int[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(int[] data) {
        return this.assign(new int[][]{data})[0];
    }

    public void assignDistance(int[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(int[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((int[][])new int[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    public IntNearestNeighboursExact getNN() {
        return this.nn;
    }
}

