/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.knn.DoubleNearestNeighboursExact;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntDoublePair;

public class ExactDoubleAssigner
implements HardAssigner<double[], double[], IntDoublePair> {
    protected DoubleNearestNeighboursExact nn;

    public ExactDoubleAssigner(CentroidsProvider<double[]> provider) {
        this(provider, null);
    }

    public ExactDoubleAssigner(CentroidsProvider<double[]> provider, DoubleFVComparator comparison) {
        this.nn = new DoubleNearestNeighboursExact((double[][])provider.getCentroids(), comparison);
    }

    public ExactDoubleAssigner(double[][] data, DoubleFVComparator comparison) {
        this.nn = new DoubleNearestNeighboursExact(data, comparison);
    }

    public int[] assign(double[][] data) {
        int[] argmins = new int[data.length];
        double[] mins = new double[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(double[] data) {
        return this.assign(new double[][]{data})[0];
    }

    public void assignDistance(double[][] data, int[] indices, double[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntDoublePair assignDistance(double[] data) {
        int[] index = new int[1];
        double[] distance = new double[1];
        this.nn.searchNN((double[][])new double[][]{data}, index, distance);
        return new IntDoublePair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    public DoubleNearestNeighboursExact getNN() {
        return this.nn;
    }
}

