/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.datasets;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLDouble;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.openimaj.data.DataUtils;
import org.openimaj.data.dataset.VFSGroupDataset;
import org.openimaj.data.dataset.VFSListDataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.image.Image;
import org.openimaj.image.ImageProvider;
import org.openimaj.image.ImageUtilities;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.io.ObjectReader;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;

@DatasetDescription(name="CalTech101", description="Pictures of objects belonging to 101 categories. About 40 to 800 images per category. Most categories have about 50 images. The size of each image is roughly 300 x 200 pixels.", creator="Fei-Fei Li, Marco Andreetto, and Marc 'Aurelio Ranzato", url="http://www.vision.caltech.edu/Image_Datasets/Caltech101/", downloadUrls={"http://datasets.openimaj.org/Caltech101/101_ObjectCategories.zip", "http://datasets.openimaj.org/Caltech101/Annotations.zip"})
public class Caltech101 {
    private static final String IMAGES_ZIP = "Caltech101/101_ObjectCategories.zip";
    private static final String IMAGES_DOWNLOAD_URL = "http://datasets.openimaj.org/Caltech101/101_ObjectCategories.zip";
    private static final String ANNOTATIONS_ZIP = "Caltech101/Annotations.zip";
    private static final String ANNOTATIONS_DOWNLOAD_URL = "http://datasets.openimaj.org/Caltech101/Annotations.zip";

    private Caltech101() {
    }

    public static <IMAGE extends Image<?, IMAGE>> VFSGroupDataset<IMAGE> getImages(InputStreamObjectReader<IMAGE> reader) throws IOException {
        return new VFSGroupDataset(Caltech101.downloadAndGetImagePath(), reader);
    }

    private static String downloadAndGetImagePath() throws IOException {
        File dataset = DataUtils.getDataLocation((String)IMAGES_ZIP);
        if (!dataset.exists()) {
            dataset.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)new URL(IMAGES_DOWNLOAD_URL), (File)dataset);
        }
        return "zip:file:" + dataset.toString() + "!101_ObjectCategories/";
    }

    private static String downloadAndGetAnnotationPath() throws IOException {
        File dataset = DataUtils.getDataLocation((String)ANNOTATIONS_ZIP);
        if (!dataset.exists()) {
            dataset.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)new URL(ANNOTATIONS_DOWNLOAD_URL), (File)dataset);
        }
        return "zip:file:" + dataset.toString() + "!Annotations/";
    }

    public static <IMAGE extends Image<?, IMAGE>> VFSGroupDataset<Record<IMAGE>> getData(InputStreamObjectReader<IMAGE> reader) throws IOException {
        return new VFSGroupDataset(Caltech101.downloadAndGetImagePath(), new RecordReader<IMAGE>(reader));
    }

    private static class RecordReader<IMAGE extends Image<?, IMAGE>>
    implements ObjectReader<Record<IMAGE>, FileObject> {
        private VFSListDataset.FileObjectISReader<IMAGE> imageReader;

        public RecordReader(InputStreamObjectReader<IMAGE> reader) {
            this.imageReader = new VFSListDataset.FileObjectISReader(reader);
        }

        public Record<IMAGE> read(final FileObject source) throws IOException {
            return new Record<IMAGE>(source){

                public IMAGE getImage() {
                    try {
                        return (Image)RecordReader.this.imageReader.read(source);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canRead(FileObject source, String name) {
            InputStream stream = null;
            try {
                stream = source.getContent().getInputStream();
                boolean bl = ImageUtilities.FIMAGE_READER.canRead(stream, source.getName().getBaseName());
                return bl;
            }
            catch (FileSystemException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static abstract class Record<IMAGE extends Image<?, IMAGE>>
    implements Identifiable,
    ImageProvider<IMAGE> {
        private Rectangle bounds;
        private Polygon contour;
        private String id;
        private String objectClass;

        protected Record(FileObject image) throws FileSystemException, IOException {
            FileSystemManager fsManager = VFS.getManager();
            FileObject imagesBase = fsManager.resolveFile(Caltech101.downloadAndGetImagePath());
            FileObject annotationsBase = fsManager.resolveFile(Caltech101.downloadAndGetAnnotationPath());
            this.id = imagesBase.getName().getRelativeName(image.getName());
            this.objectClass = image.getParent().getName().getBaseName();
            String annotationFileName = this.id.replace("image_", "annotation_").replace(".jpg", ".mat");
            FileObject annotationFile = annotationsBase.resolveFile(annotationFileName);
            this.parseAnnotations(annotationFile);
        }

        private void parseAnnotations(FileObject annotationFile) throws IOException {
            if (!annotationFile.exists()) {
                return;
            }
            MatFileReader reader = new MatFileReader(annotationFile.getContent().getInputStream());
            MLDouble boxes = (MLDouble)reader.getMLArray("box_coord");
            this.bounds = new Rectangle((float)((Double)boxes.getReal(2)).doubleValue() - 1.0f, (float)((Double)boxes.getReal(0)).doubleValue() - 1.0f, (float)((Double)boxes.getReal(3) - (Double)boxes.getReal(2)) - 1.0f, (float)((Double)boxes.getReal(1) - (Double)boxes.getReal(0)) - 1.0f);
            double[][] contourData = ((MLDouble)reader.getMLArray("obj_contour")).getArray();
            this.contour = new Polygon();
            for (int i = 0; i < contourData[0].length; ++i) {
                this.contour.points.add(new Point2dImpl((float)contourData[0][i] + this.bounds.x - 1.0f, (float)contourData[1][i] + this.bounds.y - 1.0f));
            }
            this.contour.close();
        }

        public String getID() {
            return this.id;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public Polygon getContour() {
            return this.contour;
        }

        public String getObjectClass() {
            return this.objectClass;
        }
    }
}

