/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.FewEigenvalues;
import java.util.Iterator;
import org.openimaj.ml.clustering.spectral.EigenChooser;
import org.openimaj.util.pair.DoubleObjectPair;

public class AbsoluteValueEigenChooser
extends EigenChooser {
    private double absoluteGap;
    private double maxSelect;

    public AbsoluteValueEigenChooser(double absoluteGap, double maxSelect) {
        this.absoluteGap = absoluteGap;
        this.maxSelect = maxSelect;
    }

    @Override
    public int nEigenVectors(Iterator<DoubleObjectPair<Vector>> vals, int totalEigenVectors) {
        double diff;
        double val;
        double max = -1.7976931348623157E308;
        double[] valids = new double[totalEigenVectors];
        valids[0] = vals.next().first;
        int i = 1;
        while (vals.hasNext() && !((val = vals.next().first) < 0.0)) {
            valids[i] = val;
            max = Math.max(max, valids[i]);
            ++i;
        }
        int maxindex = i + 1;
        int count = 2;
        double first = valids[1];
        for (int j = 2; j < maxindex && !((diff = Math.abs(first - valids[j])) / max > this.absoluteGap); ++j) {
            ++count;
        }
        return count;
    }

    public FewEigenvalues prepare(SparseMatrix laplacian) {
        int total = laplacian.columnCount();
        FewEigenvalues eig = FewEigenvalues.of((Matrix)laplacian);
        return eig.greatest((int)((double)total * this.maxSelect));
    }

    public String toString() {
        return String.format("AbsVal=%2.2f,%2.2f", this.absoluteGap, this.maxSelect);
    }
}

