/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.concurrent.ExecutorService;
import org.openimaj.knn.NearestNeighbours;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.util.parallel.GlobalExecutorPool;

public class KMeansConfiguration<NN extends NearestNeighbours<DATA, ?, ?>, DATA>
implements Cloneable {
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    public static final int DEFAULT_NUMBER_ITERATIONS = 30;
    protected int K;
    protected NearestNeighboursFactory<? extends NN, DATA> factory;
    protected int blockSize;
    protected int niters;
    protected ExecutorService threadpool;

    public KMeansConfiguration(int K, NearestNeighboursFactory<? extends NN, DATA> nnFactory) {
        this(K, nnFactory, 30, 50000, GlobalExecutorPool.getPool());
    }

    public KMeansConfiguration(int K, NearestNeighboursFactory<? extends NN, DATA> nnFactory, int niters) {
        this(K, nnFactory, niters, 50000, GlobalExecutorPool.getPool());
    }

    public KMeansConfiguration(int K, NearestNeighboursFactory<? extends NN, DATA> nnFactory, int niters, ExecutorService threadpool) {
        this(K, nnFactory, niters, 50000, threadpool);
    }

    public KMeansConfiguration(int K, NearestNeighboursFactory<? extends NN, DATA> nnFactory, int niters, int blockSize, ExecutorService threadpool) {
        this.K = K;
        this.factory = nnFactory;
        this.niters = niters;
        this.blockSize = blockSize;
        this.threadpool = threadpool == null ? GlobalExecutorPool.getPool() : threadpool;
    }

    public KMeansConfiguration() {
        this(0, null);
    }

    public KMeansConfiguration<NN, DATA> clone() {
        try {
            return (KMeansConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getK() {
        return this.K;
    }

    public void setK(int k) {
        this.K = k;
    }

    public int numClusters() {
        return this.K;
    }

    public void setNumClusters(int k) {
        this.K = k;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public int getMaxIterations() {
        return this.niters;
    }

    public void setMaxIterations(int niters) {
        this.niters = niters;
    }

    public NearestNeighboursFactory<? extends NN, DATA> getNearestNeighbourFactory() {
        return this.factory;
    }

    public void setNearestNeighbourFactory(NearestNeighboursFactory<? extends NN, DATA> factory) {
        this.factory = factory;
    }
}

