/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.openimaj.data.DataSource;
import org.openimaj.data.DoubleArrayBackedDataSource;
import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.knn.DoubleNearestNeighboursExact;
import org.openimaj.knn.DoubleNearestNeighboursProvider;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.knn.approximate.DoubleNearestNeighboursKDTree;
import org.openimaj.ml.clustering.DoubleCentroidsResult;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactDoubleAssigner;
import org.openimaj.ml.clustering.assignment.hard.KDTreeDoubleEuclideanAssigner;
import org.openimaj.ml.clustering.kmeans.DoubleKMeansInit;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.util.pair.IntDoublePair;

public class DoubleKMeans
implements SpatialClusterer<DoubleCentroidsResult, double[]> {
    private DoubleKMeansInit init = new DoubleKMeansInit.RANDOM();
    private KMeansConfiguration<DoubleNearestNeighbours, double[]> conf;
    private Random rng = new Random();

    public DoubleKMeans(KMeansConfiguration<DoubleNearestNeighbours, double[]> conf) {
        this.conf = conf;
    }

    protected DoubleKMeans() {
        this(new KMeansConfiguration<DoubleNearestNeighbours, double[]>());
    }

    public DoubleKMeansInit getInit() {
        return this.init;
    }

    public void setInit(DoubleKMeansInit init) {
        this.init = init;
    }

    public void seed(long seed) {
        this.rng = seed < 0L ? new Random() : new Random(seed);
    }

    public Result cluster(double[][] data) {
        DoubleArrayBackedDataSource ds = new DoubleArrayBackedDataSource(data, this.rng);
        try {
            Result result = this.cluster((DataSource<double[]>)ds, this.conf.K);
            result.nn = (DoubleNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[][] performClustering(double[][] data) {
        Result clusters = this.cluster(data);
        return new IndexClusters(((DoubleCentroidsResult)clusters).defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    protected Result cluster(DataSource<double[]> data, int K) throws Exception {
        int D = data.numDimensions();
        Result result = new Result();
        result.centroids = new double[K][D];
        this.init.initKMeans(data, result.centroids);
        this.cluster(data, result);
        return result;
    }

    public void cluster(double[][] data, Result result) throws InterruptedException {
        DoubleArrayBackedDataSource ds = new DoubleArrayBackedDataSource(data, this.rng);
        this.cluster((DataSource<double[]>)ds, result);
    }

    public void cluster(DataSource<double[]> data, Result result) throws InterruptedException {
        double[][] centroids = result.centroids;
        int K = centroids.length;
        int D = centroids[0].length;
        int N = data.size();
        double[][] centroids_accum = new double[K][D];
        int[] new_counts = new int[K];
        ExecutorService service = this.conf.threadpool;
        for (int i = 0; i < this.conf.niters; ++i) {
            ++result.iterations;
            for (int j = 0; j < K; ++j) {
                Arrays.fill(centroids_accum[j], 0.0);
            }
            Arrays.fill(new_counts, 0);
            DoubleNearestNeighbours nno = (DoubleNearestNeighbours)this.conf.factory.create((Object[])centroids);
            ArrayList<CentroidAssignmentJob> jobs = new ArrayList<CentroidAssignmentJob>();
            for (int bl = 0; bl < N; bl += this.conf.blockSize) {
                int br = Math.min(bl + this.conf.blockSize, N);
                jobs.add(new CentroidAssignmentJob(data, bl, br, nno, centroids_accum, new_counts));
            }
            service.invokeAll(jobs);
            result.changedCentroidCount = 0;
            for (int k = 0; k < K; ++k) {
                double ssd = 0.0;
                if (new_counts[k] == 0) {
                    new_counts[k] = 1;
                    double[][] rnd = new double[][]{centroids[k]};
                    data.getRandomRows((Object[])rnd);
                    ++result.changedCentroidCount;
                    continue;
                }
                for (int d = 0; d < D; ++d) {
                    double newValue = this.roundDouble(centroids_accum[k][d] / (double)new_counts[k]);
                    double diff = newValue - centroids[k][d];
                    ssd += diff * diff;
                    centroids[k][d] = newValue;
                }
                if (ssd == 0.0) continue;
                ++result.changedCentroidCount;
            }
            if (result.changedCentroidCount == 0) break;
        }
    }

    protected float roundFloat(double value) {
        return (float)value;
    }

    protected double roundDouble(double value) {
        return value;
    }

    protected long roundLong(double value) {
        return Math.round(value);
    }

    protected int roundInt(double value) {
        return (int)Math.round(value);
    }

    @Override
    public Result cluster(DataSource<double[]> ds) {
        try {
            Result result = this.cluster(ds, this.conf.K);
            result.nn = (DoubleNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KMeansConfiguration<DoubleNearestNeighbours, double[]> getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(KMeansConfiguration<DoubleNearestNeighbours, double[]> conf) {
        this.conf = conf;
    }

    public static DoubleKMeans createExact(int K) {
        KMeansConfiguration<DoubleNearestNeighbours, double[]> conf = new KMeansConfiguration<DoubleNearestNeighbours, double[]>(K, (NearestNeighboursFactory<DoubleNearestNeighbours, double[]>)new DoubleNearestNeighboursExact.Factory());
        return new DoubleKMeans(conf);
    }

    public static DoubleKMeans createExact(int K, int niters) {
        KMeansConfiguration<DoubleNearestNeighbours, double[]> conf = new KMeansConfiguration<DoubleNearestNeighbours, double[]>(K, (NearestNeighboursFactory<DoubleNearestNeighbours, double[]>)new DoubleNearestNeighboursExact.Factory(), niters);
        return new DoubleKMeans(conf);
    }

    public static DoubleKMeans createKDTreeEnsemble(int K) {
        KMeansConfiguration<DoubleNearestNeighbours, double[]> conf = new KMeansConfiguration<DoubleNearestNeighbours, double[]>(K, (NearestNeighboursFactory<DoubleNearestNeighbours, double[]>)new DoubleNearestNeighboursKDTree.Factory());
        return new DoubleKMeans(conf);
    }

    public String toString() {
        return String.format("%s: {K=%d, NN=%s}", this.getClass().getSimpleName(), this.conf.K, this.conf.getNearestNeighbourFactory().getClass().getSimpleName());
    }

    public static class Result
    extends DoubleCentroidsResult
    implements DoubleNearestNeighboursProvider {
        protected DoubleNearestNeighbours nn;
        protected int iterations;
        protected int changedCentroidCount;

        @Override
        public HardAssigner<double[], double[], IntDoublePair> defaultHardAssigner() {
            if (this.nn instanceof DoubleNearestNeighboursExact) {
                return new ExactDoubleAssigner(this, ((DoubleNearestNeighboursExact)this.nn).distanceComparator());
            }
            return new KDTreeDoubleEuclideanAssigner(this);
        }

        public DoubleNearestNeighbours getNearestNeighbours() {
            return this.nn;
        }

        public int numIterations() {
            return this.iterations;
        }

        public int numChangedCentroids() {
            return this.changedCentroidCount;
        }
    }

    private static class CentroidAssignmentJob
    implements Callable<Boolean> {
        private final DataSource<double[]> ds;
        private final int startRow;
        private final int stopRow;
        private final DoubleNearestNeighbours nno;
        private final double[][] centroids_accum;
        private final int[] counts;

        public CentroidAssignmentJob(DataSource<double[]> ds, int startRow, int stopRow, DoubleNearestNeighbours nno, double[][] centroids_accum, int[] counts) {
            this.ds = ds;
            this.startRow = startRow;
            this.stopRow = stopRow;
            this.nno = nno;
            this.centroids_accum = centroids_accum;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                int D = this.nno.numDimensions();
                double[][] points = new double[this.stopRow - this.startRow][D];
                this.ds.getData(this.startRow, this.stopRow, (Object[])points);
                int[] argmins = new int[points.length];
                double[] mins = new double[points.length];
                this.nno.searchNN((Object[])points, argmins, (Object)mins);
                double[][] dArray = this.centroids_accum;
                synchronized (this.centroids_accum) {
                    for (int i = 0; i < points.length; ++i) {
                        int k = argmins[i];
                        for (int d = 0; d < D; ++d) {
                            double[] dArray2 = this.centroids_accum[k];
                            int n = d;
                            dArray2[n] = dArray2[n] + points[i][d];
                        }
                        int n = k;
                        this.counts[n] = this.counts[n] + 1;
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            {
                return true;
            }
        }
    }
}

