/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import org.openimaj.feature.IntFVComparator;
import org.openimaj.feature.IntFVComparison;
import org.openimaj.knn.IntNearestNeighbours;
import org.openimaj.knn.IntNearestNeighboursExact;
import org.openimaj.knn.IntNearestNeighboursProvider;
import org.openimaj.knn.approximate.IntNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.util.pair.IndependentPair;

public class IntKNNAssigner
implements SoftAssigner<int[], float[]> {
    protected IntNearestNeighbours nn;
    protected int numNeighbours;

    public IntKNNAssigner(CentroidsProvider<int[]> provider, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        if (exact) {
            this.nn = new IntNearestNeighboursExact((int[][])provider.getCentroids());
        } else {
            IntNearestNeighbours internal;
            if (provider instanceof IntNearestNeighboursProvider && (internal = ((IntNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof IntNearestNeighboursKDTree) {
                this.nn = (IntNearestNeighboursKDTree)internal;
                return;
            }
            this.nn = new IntNearestNeighboursKDTree((int[][])provider.getCentroids(), 8, 768);
        }
    }

    public IntKNNAssigner(int[][] data, boolean exact, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = exact ? new IntNearestNeighboursExact(data) : new IntNearestNeighboursKDTree(data, 8, 768);
    }

    public IntKNNAssigner(CentroidsProvider<int[]> provider, IntFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new IntNearestNeighboursExact((int[][])provider.getCentroids(), (IntFVComparator)comparison);
    }

    public IntKNNAssigner(int[][] data, IntFVComparison comparison, int numNeighbours) {
        this.numNeighbours = numNeighbours;
        this.nn = new IntNearestNeighboursExact(data, (IntFVComparator)comparison);
    }

    public int[][] assign(int[][] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])data, this.numNeighbours, indices, (Object[])distances);
        return indices;
    }

    @Override
    public int[] assign(int[] data) {
        return this.assign(new int[][]{data})[0];
    }

    public void assignWeighted(int[][] data, int[][] assignments, float[][] weights) {
        this.nn.searchKNN((Object[])data, this.numNeighbours, assignments, (Object[])weights);
    }

    @Override
    public IndependentPair<int[], float[]> assignWeighted(int[] data) {
        int[][] indices = new int[data.length][this.numNeighbours];
        float[][] distances = new float[data.length][this.numNeighbours];
        this.nn.searchKNN((Object[])new int[][]{data}, this.numNeighbours, indices, (Object[])distances);
        return new IndependentPair((Object)indices[0], (Object)distances[0]);
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }

    @Override
    public int size() {
        return this.nn.size();
    }
}

