/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

@Reference(author={"Y. Cai", "W. Tong", "L. Yang", "A. G. Hauptmann"}, title="Constrained Keypoint Quantization: Towards Better Bag-of-Words Model for Large-scale Multimedia Retrieval", type=ReferenceType.Inproceedings, year="2012", booktitle="ACM International Conference on Multimedia Retrieval", customData={"location", "Hong Kong, China"})
public class ConstrainedFloatAssigner<DATATYPE>
implements HardAssigner<DATATYPE, float[], IntFloatPair> {
    HardAssigner<DATATYPE, float[], IntFloatPair> internalAssigner;
    boolean allowIfGreater = false;
    float threshold;

    public ConstrainedFloatAssigner(HardAssigner<DATATYPE, float[], IntFloatPair> internalAssigner, float threshold) {
        this.threshold = threshold;
    }

    public ConstrainedFloatAssigner(HardAssigner<DATATYPE, float[], IntFloatPair> internalAssigner, float threshold, boolean greater) {
        this.allowIfGreater = greater;
        this.threshold = threshold;
    }

    private boolean allow(float distance) {
        if (this.allowIfGreater) {
            return distance > this.threshold;
        }
        return distance < this.threshold;
    }

    @Override
    public int[] assign(DATATYPE[] data) {
        int[] indices = new int[data.length];
        float[] distances = new float[data.length];
        this.assignDistance(data, indices, distances);
        return indices;
    }

    @Override
    public int assign(DATATYPE data) {
        return this.assignDistance(data).first;
    }

    @Override
    public void assignDistance(DATATYPE[] data, int[] indices, float[] distances) {
        this.internalAssigner.assignDistance(data, indices, distances);
        for (int i = 0; i < data.length; ++i) {
            if (this.allow(distances[i])) continue;
            distances[i] = Float.NaN;
            indices[i] = -1;
        }
    }

    @Override
    public IntFloatPair assignDistance(DATATYPE data) {
        IntFloatPair res = this.internalAssigner.assignDistance(data);
        if (!this.allow(res.second)) {
            res.second = Float.NaN;
            res.first = -1;
        }
        return res;
    }

    @Override
    public int size() {
        return this.internalAssigner.size();
    }

    @Override
    public int numDimensions() {
        return this.internalAssigner.numDimensions();
    }
}

