/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.SpatialClusters;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactDoubleAssigner;
import org.openimaj.util.pair.IntDoublePair;

public class DoubleCentroidsResult
implements SpatialClusters<double[]>,
CentroidsProvider<double[]> {
    static final String HEADER = "CLST" + "Double".charAt(0) + "Cen";
    public double[][] centroids;

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleCentroidsResult)) {
            return false;
        }
        DoubleCentroidsResult other = (DoubleCentroidsResult)obj;
        for (int i = 0; i < this.centroids.length; ++i) {
            if (Arrays.equals(this.centroids[i], other.centroids[i])) continue;
            return false;
        }
        return true;
    }

    public String asciiHeader() {
        return "ASCII" + HEADER;
    }

    public byte[] binaryHeader() {
        return HEADER.getBytes();
    }

    public void readASCII(Scanner br) throws IOException {
        int K = Integer.parseInt(br.nextLine().trim());
        int M = Integer.parseInt(br.nextLine().trim());
        this.centroids = new double[K][M];
        for (int k = 0; k < K; ++k) {
            String[] parts = br.nextLine().split(",");
            for (int d = 0; d < M; ++d) {
                this.centroids[k][d] = Double.parseDouble(parts[d]);
            }
        }
    }

    public void readBinary(DataInput in) throws IOException {
        int K = in.readInt();
        int M = in.readInt();
        this.centroids = new double[K][M];
        for (int k = 0; k < K; ++k) {
            for (int d = 0; d < M; ++d) {
                this.centroids[k][d] = in.readDouble();
            }
        }
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        writer.println(this.centroids.length);
        writer.println(this.centroids[0].length);
        for (int k = 0; k < this.centroids.length; ++k) {
            for (int d = 0; d < this.centroids[0].length; ++d) {
                writer.print(this.centroids[k][d] + ",");
            }
            writer.println();
        }
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.centroids.length);
        out.writeInt(this.centroids[0].length);
        for (int k = 0; k < this.centroids.length; ++k) {
            for (int d = 0; d < this.centroids[0].length; ++d) {
                out.writeDouble(this.centroids[k][d]);
            }
        }
    }

    public String toString() {
        String str = "";
        str = str + "DoubleCentroidsResult\n";
        str = str + "No. of Clusters: " + this.centroids.length + "\n";
        str = str + "No. of Dimensions: " + this.centroids[0].length + "\n";
        return str;
    }

    public double[][] getCentroids() {
        return this.centroids;
    }

    @Override
    public HardAssigner<double[], double[], IntDoublePair> defaultHardAssigner() {
        return new ExactDoubleAssigner(this);
    }

    @Override
    public int numDimensions() {
        return this.centroids[0].length;
    }

    @Override
    public int numClusters() {
        return this.centroids.length;
    }
}

