/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.knn.ShortNearestNeighboursExact;
import org.openimaj.knn.pq.ShortProductQuantiser;
import org.openimaj.ml.clustering.kmeans.ShortKMeans;

public final class ShortProductQuantiserUtilities {
    private ShortProductQuantiserUtilities() {
    }

    public static ShortProductQuantiser train(short[][] data, int numAssigners, int K, int nIter) {
        if (K > 256 || K <= 0) {
            throw new IllegalArgumentException("0 <= K < 256");
        }
        int subDim = data[0].length / numAssigners;
        short[][] tmp = new short[data.length][subDim];
        ShortNearestNeighboursExact[] assigners = new ShortNearestNeighboursExact[numAssigners];
        ShortKMeans kmeans = ShortKMeans.createExact(K, 100);
        for (int i = 0; i < numAssigners; ++i) {
            for (int j = 0; j < data.length; ++j) {
                System.arraycopy(data[j], i * subDim, tmp[j], 0, subDim);
            }
            ShortKMeans.Result centroids = kmeans.cluster(tmp);
            assigners[i] = (ShortNearestNeighboursExact)centroids.getNearestNeighbours();
        }
        return new ShortProductQuantiser(assigners);
    }

    public static ShortProductQuantiser train(short[][] data, int numAssigners, int nIter) {
        return ShortProductQuantiserUtilities.train(data, numAssigners, 256, nIter);
    }
}

