/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene42.Lucene42Codec;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.sorter.Sorter;
import org.apache.lucene.index.sorter.SortingAtomicReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.spell.TermFreqPayloadIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public class AnalyzingInfixSuggester
extends Lookup
implements Closeable {
    protected static final String TEXT_FIELD_NAME = "text";
    private final Analyzer queryAnalyzer;
    private final Analyzer indexAnalyzer;
    private final Version matchVersion;
    private final File indexPath;
    private final int minPrefixChars;
    private Directory dir;
    protected IndexSearcher searcher;
    private BinaryDocValues payloadsDV;
    private BinaryDocValues textDV;
    private NumericDocValues weightsDV;
    public static final int DEFAULT_MIN_PREFIX_CHARS = 4;

    public AnalyzingInfixSuggester(Version matchVersion, File indexPath, Analyzer analyzer) throws IOException {
        this(matchVersion, indexPath, analyzer, analyzer, 4);
    }

    public AnalyzingInfixSuggester(Version matchVersion, File indexPath, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars) throws IOException {
        if (minPrefixChars < 0) {
            throw new IllegalArgumentException("minPrefixChars must be >= 0; got: " + minPrefixChars);
        }
        this.queryAnalyzer = queryAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
        this.matchVersion = matchVersion;
        this.indexPath = indexPath;
        this.minPrefixChars = minPrefixChars;
        this.dir = this.getDirectory(indexPath);
        if (DirectoryReader.indexExists((Directory)this.dir)) {
            this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.dir));
            this.payloadsDV = MultiDocValues.getBinaryValues((IndexReader)this.searcher.getIndexReader(), (String)"payloads");
            this.weightsDV = MultiDocValues.getNumericValues((IndexReader)this.searcher.getIndexReader(), (String)"weight");
            this.textDV = MultiDocValues.getBinaryValues((IndexReader)this.searcher.getIndexReader(), (String)TEXT_FIELD_NAME);
            assert (this.textDV != null);
        }
    }

    protected IndexWriterConfig getIndexWriterConfig(Version matchVersion, Analyzer indexAnalyzer) {
        IndexWriterConfig iwc = new IndexWriterConfig(matchVersion, indexAnalyzer);
        iwc.setCodec((Codec)new Lucene42Codec());
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        return iwc;
    }

    protected Directory getDirectory(File path) throws IOException {
        return FSDirectory.open((File)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(TermFreqIterator iter) throws IOException {
        block11: {
            SlowCompositeReaderWrapper r;
            IndexWriter w2;
            IndexWriter w;
            Directory dirTmp;
            block10: {
                if (this.searcher != null) {
                    this.searcher.getIndexReader().close();
                    this.searcher = null;
                }
                TermFreqPayloadIterator payloads = iter instanceof TermFreqPayloadIterator ? (TermFreqPayloadIterator)iter : null;
                dirTmp = this.getDirectory(new File(this.indexPath.toString() + ".tmp"));
                w = null;
                w2 = null;
                r = null;
                boolean success = false;
                try {
                    BytesRef text;
                    BinaryDocValuesField payloadField;
                    AnalyzerWrapper gramAnalyzer = new AnalyzerWrapper(){

                        protected Analyzer getWrappedAnalyzer(String fieldName) {
                            return AnalyzingInfixSuggester.this.indexAnalyzer;
                        }

                        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                            if (fieldName.equals("textgrams") && AnalyzingInfixSuggester.this.minPrefixChars > 0) {
                                return new Analyzer.TokenStreamComponents(components.getTokenizer(), (TokenStream)new EdgeNGramTokenFilter(AnalyzingInfixSuggester.this.matchVersion, components.getTokenStream(), 1, AnalyzingInfixSuggester.this.minPrefixChars));
                            }
                            return components;
                        }
                    };
                    w = new IndexWriter(dirTmp, this.getIndexWriterConfig(this.matchVersion, (Analyzer)gramAnalyzer));
                    Document doc = new Document();
                    FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
                    ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
                    ft.setOmitNorms(true);
                    Field textField = new Field(TEXT_FIELD_NAME, "", ft);
                    doc.add((IndexableField)textField);
                    Field textGramField = new Field("textgrams", "", ft);
                    doc.add((IndexableField)textGramField);
                    BinaryDocValuesField textDVField = new BinaryDocValuesField(TEXT_FIELD_NAME, new BytesRef());
                    doc.add((IndexableField)textDVField);
                    NumericDocValuesField weightField = new NumericDocValuesField("weight", 0L);
                    doc.add((IndexableField)weightField);
                    if (payloads != null) {
                        payloadField = new BinaryDocValuesField("payloads", new BytesRef());
                        doc.add((IndexableField)payloadField);
                    } else {
                        payloadField = null;
                    }
                    while ((text = iter.next()) != null) {
                        String textString = text.utf8ToString();
                        textField.setStringValue(textString);
                        textGramField.setStringValue(textString);
                        textDVField.setBytesValue(text);
                        weightField.setLongValue(iter.weight());
                        if (payloads != null) {
                            payloadField.setBytesValue(payloads.payload());
                        }
                        w.addDocument((Iterable)doc);
                    }
                    r = new SlowCompositeReaderWrapper((CompositeReader)DirectoryReader.open((IndexWriter)w, (boolean)false));
                    w.rollback();
                    final int maxDoc = r.maxDoc();
                    final NumericDocValues weights = r.getNumericDocValues("weight");
                    final Sorter.DocComparator comparator = new Sorter.DocComparator(){

                        public int compare(int docID1, int docID2) {
                            long v2;
                            long v1 = weights.get(docID1);
                            if (v1 > (v2 = weights.get(docID2))) {
                                return -1;
                            }
                            if (v1 < v2) {
                                return 1;
                            }
                            return 0;
                        }
                    };
                    r = SortingAtomicReader.wrap((AtomicReader)r, (Sorter)new Sorter(){

                        public Sorter.DocMap sort(AtomicReader reader) throws IOException {
                            return Sorter.sort((int)maxDoc, (Sorter.DocComparator)comparator);
                        }

                        public String getID() {
                            return "Weight";
                        }
                    });
                    w2 = new IndexWriter(this.dir, this.getIndexWriterConfig(this.matchVersion, this.indexAnalyzer));
                    w2.addIndexes(new IndexReader[]{r});
                    r.close();
                    this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)w2, (boolean)false));
                    w2.close();
                    this.payloadsDV = MultiDocValues.getBinaryValues((IndexReader)this.searcher.getIndexReader(), (String)"payloads");
                    this.weightsDV = MultiDocValues.getNumericValues((IndexReader)this.searcher.getIndexReader(), (String)"weight");
                    this.textDV = MultiDocValues.getBinaryValues((IndexReader)this.searcher.getIndexReader(), (String)TEXT_FIELD_NAME);
                    assert (this.textDV != null);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{w, w2, r, dirTmp});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{w, w2, r, dirTmp});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{w, w2, r, dirTmp});
                break block11;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{w, w2, r, dirTmp});
        }
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        return this.lookup(key, num, true, true);
    }

    protected Query getLastTokenQuery(String token) throws IOException {
        if (token.length() < this.minPrefixChars) {
            return new TermQuery(new Term("textgrams", token));
        }
        return new PrefixQuery(new Term(TEXT_FIELD_NAME, token));
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, int num, boolean allTermsRequired, boolean doHighlight) {
        if (this.searcher == null) {
            throw new IllegalStateException("suggester was not built");
        }
        BooleanClause.Occur occur = allTermsRequired ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        try {
            TokenStream ts = this.queryAnalyzer.tokenStream("", (Reader)new StringReader(((Object)key).toString()));
            ts.reset();
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            String lastToken = null;
            BooleanQuery query = new BooleanQuery();
            int maxEndOffset = -1;
            HashSet<String> matchedTokens = new HashSet<String>();
            while (ts.incrementToken()) {
                if (lastToken != null) {
                    matchedTokens.add(lastToken);
                    query.add((Query)new TermQuery(new Term(TEXT_FIELD_NAME, lastToken)), occur);
                }
                if ((lastToken = termAtt.toString()) == null) continue;
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
            }
            ts.end();
            String prefixToken = null;
            if (lastToken != null) {
                Query lastQuery;
                if (maxEndOffset == offsetAtt.endOffset()) {
                    lastQuery = this.getLastTokenQuery(lastToken);
                    prefixToken = lastToken;
                } else {
                    matchedTokens.add(lastToken);
                    lastQuery = new TermQuery(new Term(TEXT_FIELD_NAME, lastToken));
                }
                if (lastQuery != null) {
                    query.add(lastQuery, occur);
                }
            }
            ts.close();
            Query finalQuery = this.finishQuery(query, allTermsRequired);
            FirstNDocsCollector c = new FirstNDocsCollector(num);
            try {
                this.searcher.search(finalQuery, (Collector)c);
            }
            catch (FirstNDocsCollector.DoneException done) {
                // empty catch block
            }
            TopDocs hits = c.getHits();
            ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
            BytesRef scratch = new BytesRef();
            for (int i = 0; i < hits.scoreDocs.length; ++i) {
                BytesRef payload;
                ScoreDoc sd = hits.scoreDocs[i];
                this.textDV.get(sd.doc, scratch);
                String text = scratch.utf8ToString();
                if (doHighlight) {
                    text = this.highlight(text, matchedTokens, prefixToken);
                }
                long score = this.weightsDV.get(sd.doc);
                if (this.payloadsDV != null) {
                    payload = new BytesRef();
                    this.payloadsDV.get(sd.doc, payload);
                } else {
                    payload = null;
                }
                results.add(new Lookup.LookupResult(text, score, payload));
            }
            return results;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected Query finishQuery(BooleanQuery in, boolean allTermsRequired) {
        return in;
    }

    private String highlight(String text, Set<String> matchedTokens, String prefixToken) throws IOException {
        TokenStream ts = this.queryAnalyzer.tokenStream(TEXT_FIELD_NAME, (Reader)new StringReader(text));
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        ts.reset();
        StringBuilder sb = new StringBuilder();
        int upto = 0;
        while (ts.incrementToken()) {
            String token = termAtt.toString();
            int startOffset = offsetAtt.startOffset();
            int endOffset = offsetAtt.endOffset();
            if (upto < startOffset) {
                sb.append(text.substring(upto, startOffset));
                upto = startOffset;
            } else if (upto > startOffset) continue;
            if (matchedTokens.contains(token)) {
                this.addWholeMatch(sb, text.substring(startOffset, endOffset), token);
                upto = endOffset;
                continue;
            }
            if (prefixToken == null || !token.startsWith(prefixToken)) continue;
            this.addPrefixMatch(sb, text.substring(startOffset, endOffset), token, prefixToken);
            upto = endOffset;
        }
        ts.end();
        int endOffset = offsetAtt.endOffset();
        if (upto < endOffset) {
            sb.append(text.substring(upto));
        }
        ts.close();
        return sb.toString();
    }

    protected void addWholeMatch(StringBuilder sb, String surface, String analyzed) {
        sb.append("<b>");
        sb.append(surface);
        sb.append("</b>");
    }

    protected void addPrefixMatch(StringBuilder sb, String surface, String analyzed, String prefixToken) {
        sb.append("<b>");
        if (surface.startsWith(prefixToken)) {
            sb.append(surface.substring(0, prefixToken.length()));
            sb.append("</b>");
            sb.append(surface.substring(prefixToken.length()));
        } else {
            sb.append(surface);
            sb.append("</b>");
        }
    }

    @Override
    public boolean store(OutputStream out) {
        return false;
    }

    @Override
    public boolean load(InputStream out) {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.searcher != null) {
            this.searcher.getIndexReader().close();
            this.searcher = null;
        }
        if (this.dir != null) {
            this.dir.close();
            this.dir = null;
        }
    }

    private static class FirstNDocsCollector
    extends Collector {
        private int docBase;
        private final int[] hits;
        private int hitCount;

        public TopDocs getHits() {
            ScoreDoc[] scoreDocs = new ScoreDoc[this.hitCount];
            for (int i = 0; i < this.hitCount; ++i) {
                scoreDocs[i] = new ScoreDoc(this.hits[i], Float.NaN);
            }
            return new TopDocs(this.hitCount, scoreDocs, Float.NaN);
        }

        public FirstNDocsCollector(int topN) {
            this.hits = new int[topN];
        }

        public void collect(int doc) {
            this.hits[this.hitCount++] = doc;
            if (this.hitCount == this.hits.length) {
                throw new DoneException();
            }
        }

        public void setScorer(Scorer scorer) {
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void setNextReader(AtomicReaderContext cxt) {
            this.docBase = cxt.docBase;
        }

        private static class DoneException
        extends RuntimeException {
            private DoneException() {
            }
        }
    }
}

